package net.aihelp.data.logic;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.widget.Toast;

import net.aihelp.common.API;
import net.aihelp.common.Const;
import net.aihelp.core.mvp.AbsPresenter;
import net.aihelp.core.mvp.IRepository;
import net.aihelp.core.mvp.IView;
import net.aihelp.core.net.mqtt.AIHelpMqtt;
import net.aihelp.core.net.mqtt.config.MqttConfig;

import net.aihelp.core.util.concurrent.ApiExecutorFactory;
import net.aihelp.db.bot.ConversationDBHelper;
import net.aihelp.db.bot.controller.ElvaDBController;
import net.aihelp.ui.helper.LogoutMqttHelper;
import net.aihelp.ui.helper.ResponseMqttHelper;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.TLog;
import net.aihelp.utils.ToastUtil;

import org.json.JSONArray;
import org.json.JSONObject;


public abstract class MqttPresenter<V extends IView, R extends IRepository> extends AbsPresenter<V, R> {

    public MqttPresenter(Context context) {
        super(context);
    }

    public boolean isNetworkAvailable() {
        if (mContext == null) return false;
        ConnectivityManager cm = (ConnectivityManager) mContext.getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo networkInfo = null;
        if (cm != null) {
            networkInfo = cm.getActiveNetworkInfo();
        }
        return networkInfo != null && networkInfo.isConnected();
    }

    public boolean validateNetwork() {
        boolean isAvailable = isNetworkAvailable();
        if (!isAvailable) {
            ToastUtil.INSTANCE.makeRawToast(mContext, ResResolver.getString("aihelp_network_no_connect"));
        }
        return isAvailable;
    }

    public void logoutMqtt(boolean isConversation) {
        logoutMqtt(isConversation, -1);
    }

    public void logoutMqtt(boolean isConversation, int resolveType) {
//            if (!MqttConfig.getInstance().isConnected()) return;
        ApiExecutorFactory.getHandlerExecutor().runAsync(new Runnable() {
            @Override
            public void run() {
                try {
                    JSONObject logoutParams = new JSONObject();
                    JSONArray msgArray = ConversationDBHelper.getElvaMsgArray();
                    logoutParams.put("type", isConversation ? MqttConfig.TYPE_CONVERSATION : MqttConfig.TYPE_ELVA_BOT);
                    logoutParams.put("feedback", LogoutMqttHelper.getLogoutType());
                    logoutParams.put("gameinfo", String.format("{\"platform\":\"android\",\"language\":\"%s\"}", Const.CORRECT_LANGUAGE));
                    logoutParams.put("session_msgs", msgArray);
                    logoutParams.put("tags", LogoutMqttHelper.getTagsFromMessageList(msgArray));
                    if (resolveType != -1) {
                        JSONObject resolveObject = new JSONObject();
                        resolveObject.put("resolveType", resolveType);
                        logoutParams.put("resolveEvaluation", resolveObject);
                    }
                    AIHelpMqtt.getInstance().postToServer((API.TOPIC_LOGOUT), logoutParams);
                    LogoutMqttHelper.resetTypeWhenLogout();
                    ConversationDBHelper.clearElvaMsg();
                    // ResponseMqttHelper.resetTicketStatusFlags();
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

}
