package net.aihelp.db.bot.controller;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;

import net.aihelp.common.API;
import net.aihelp.common.Const;
import net.aihelp.common.UserProfile;
import net.aihelp.db.bot.ConversationSQLiteHelper;
import net.aihelp.db.bot.tables.ElvaBotTable;
import net.aihelp.db.util.ContentValuesUtil;

import org.json.JSONArray;
import org.json.JSONObject;


public class ElvaDBController {

    private final ConversationSQLiteHelper dbHelper;

    private ElvaDBController() {
        this.dbHelper = ConversationSQLiteHelper.getInstance();
    }

    public void storeElvaBotMsg(long timeStamp, String rawResponse) {
        try {
            SQLiteDatabase database = dbHelper.getWritableDatabase();
            database.insert(ElvaBotTable.TABLE_NAME, null,
                    ContentValuesUtil.getElvaBotContentValues(timeStamp, rawResponse));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void clearElvaMsg() {
        if (!TextUtils.isEmpty(UserProfile.USER_ID)) {
            try {
                String whereClause = "uid=?";
                String[] whereArgs = new String[]{UserProfile.USER_ID};
                SQLiteDatabase database = this.dbHelper.getWritableDatabase();
                database.delete(ElvaBotTable.TABLE_NAME, whereClause, whereArgs);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    // same user id with different app, or different server
    public JSONArray getElvaMsgArray() {
        JSONArray msgArray = new JSONArray();
        Cursor cursor = null;
        try {
            SQLiteDatabase database = this.dbHelper.getReadableDatabase();
            String whereClause = "uid = ? AND app_id = ? AND app_server = ?";
            String[] whereArgs = new String[]{
                    UserProfile.USER_ID, Const.APP_ID, API.HOST_URL
            };
            cursor = database.query(ElvaBotTable.TABLE_NAME, null, whereClause, whereArgs,
                    null, null, null);
            if (cursor != null && cursor.getCount() > 0 && cursor.moveToFirst()) {
                while (!cursor.isAfterLast()) {
                    String rawResponse = cursor.getString(cursor.getColumnIndex(ElvaBotTable.Columns.RAW_RESPONSE));
                    msgArray.put(new JSONObject(rawResponse));
                    cursor.moveToNext();
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return msgArray;
    }

    private static final class LazyHolder {
        static final ElvaDBController INSTANCE = new ElvaDBController();

        private LazyHolder() {
        }

    }

    public static ElvaDBController getInstance() {
        return ElvaDBController.LazyHolder.INSTANCE;
    }

}
