package net.aihelp.db.util;

import android.content.ContentValues;

import net.aihelp.common.API;
import net.aihelp.common.Const;
import net.aihelp.common.UserProfile;

import net.aihelp.db.bot.tables.ElvaBotTable;

public class ContentValuesUtil {

    public static ContentValues getElvaBotContentValues(long timeStamp, String rawResponse) {
        ContentValues values = new ContentValues();
        values.put(ElvaBotTable.Columns.UID, UserProfile.USER_ID);
        values.put(ElvaBotTable.Columns.APP_ID, Const.APP_ID);
        values.put(ElvaBotTable.Columns.APP_SERVER, API.HOST_URL);
        values.put(ElvaBotTable.Columns.TIME_STAMP, timeStamp);
        values.put(ElvaBotTable.Columns.RAW_RESPONSE, rawResponse);
        return values;
    }

}
