package net.aihelp.ui;

import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Color;
import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.LinearInterpolator;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;

import net.aihelp.common.Const;
import net.aihelp.common.CustomConfig;
import net.aihelp.common.IntentValues;
import net.aihelp.core.net.monitor.NetworkMonitorManager;
import net.aihelp.core.net.mqtt.AIHelpMqtt;
import net.aihelp.core.net.mqtt.config.MqttConfig;
import net.aihelp.core.ui.BaseFragment;
import net.aihelp.core.ui.image.Picasso;
import net.aihelp.core.util.bus.event.EventCenter;
import net.aihelp.core.util.concurrent.ApiExecutorFactory;
import net.aihelp.data.event.FatalErrorEvent;
import net.aihelp.data.event.SearchViewVisibilityChangeEvent;
import net.aihelp.data.event.LoadingElvaEvent;
import net.aihelp.data.event.OperatePagerEvent;
import net.aihelp.data.event.OrientationChangeEvent;
import net.aihelp.data.event.SupportActionEvent;
import net.aihelp.data.event.PageHoppingEvent;
import net.aihelp.data.event.UpdateTitleEvent;
import net.aihelp.ui.cs.BaseCSFragment;
import net.aihelp.ui.cs.ConversationFragment;
import net.aihelp.ui.cs.ElvaBotFragment;
import net.aihelp.ui.cs.IntentUrlFragment;
import net.aihelp.ui.faq.BaseFaqFragment;
import net.aihelp.ui.faq.FaqContentFragment;
import net.aihelp.ui.faq.FaqHomeFragment;
import net.aihelp.ui.faq.FaqSearchFragment;
import net.aihelp.ui.faq.IFaqEventListener;
import net.aihelp.ui.faq.IFaqParentView;
import net.aihelp.ui.helper.BreakReleaseHelper;
import net.aihelp.ui.helper.FragmentHelper;
import net.aihelp.ui.helper.StatisticHelper;
import net.aihelp.ui.helper.SupportHelper;
import net.aihelp.ui.op.OperationFragment;
import net.aihelp.ui.widget.AIHelpFakeSearch;
import net.aihelp.ui.widget.AIHelpMsgView;
import net.aihelp.ui.widget.AIHelpSearchView;
import net.aihelp.utils.FastClickValidator;
import net.aihelp.data.localize.LocalizeHelper;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.SoftInputUtil;
import net.aihelp.utils.Styles;
import net.aihelp.utils.TLog;

import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;

@RestrictTo(RestrictTo.Scope.LIBRARY)
public class SupportFragment extends BaseFragment implements View.OnClickListener, IFaqParentView {

    private boolean isOperateInHelpPage;
    private SupportHelper mSupportHelper;

    private ImageView ivBack;
    private ImageView ivLoading;
    private ImageView ivTitle;
    private TextView tvTitle;
    private AIHelpMsgView msgView;
    private AIHelpSearchView searchView;
    private TextView tvLogo;

    private LinearLayout fakeSearchPort;
    private AIHelpFakeSearch fakeSearchLand;

    private ObjectAnimator loadingAnimator;

    public static SupportFragment getInstance(Bundle bundle) {
        SupportFragment fraSupport = new SupportFragment();
        fraSupport.setArguments(bundle);
        return fraSupport;
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        if (mSupportHelper == null) {
            mSupportHelper = new SupportHelper(context, getRetainedChildFragmentManager(), getArguments());
        }
    }

    @Override
    public void onResume() {
        super.onResume();
        mSupportHelper.start();
    }

    @Override
    protected void getBundleBeforeDataPrepared(Bundle extras) {
        if (shouldLocalizeFAQ(extras)) {
            LocalizeHelper.getLocalizeDataFromUrl(LocalizeHelper.FLAG_FAQ_SECTION);
        }
    }

    private boolean shouldLocalizeFAQ(Bundle extras) {
        int supportMode = extras.getInt(IntentValues.SUPPORT_MODE, 0);
        return supportMode == IntentValues.MODE_OPERATE || supportMode == IntentValues.MODE_ELVA
                || supportMode == IntentValues.MODE_CONVERSATION;
    }

    @Override
    protected void initEventAndData(View view) {

        RelativeLayout rlNavigation = (RelativeLayout) get("aihelp_rl_navigation");
        rlNavigation.setBackgroundColor(Styles.getColorWithAlpha(
                CustomConfig.CommonSetting.navigationBarBackground, CustomConfig.CommonSetting.navigationBarAlpha));

        ivBack = (AppCompatImageView) get("aihelp_iv_back");
        ivLoading = (AppCompatImageView) get("aihelp_iv_loading");
        ivTitle = (ImageView) get("aihelp_iv_title");
        tvTitle = (TextView) get("aihelp_tv_title");
        msgView = (AIHelpMsgView) get("aihelp_msg_view");
        searchView = (AIHelpSearchView) get("aihelp_search_view");

        fakeSearchPort = (LinearLayout) get("aihelp_fake_search_port");
        fakeSearchPort.setBackgroundColor(Styles.getColorWithAlpha(
                CustomConfig.CommonSetting.navigationBarBackground, CustomConfig.CommonSetting.navigationBarAlpha));
        fakeSearchLand = (AIHelpFakeSearch) get("aihelp_fake_search_land");

        Styles.reRenderImageView(ivBack, "aihelp_svg_ic_back", true);
        Styles.reRenderImageView(ivLoading, "aihelp_svg_ic_loading");

        msgView.setOnClickListener(this);
        ivBack.setOnClickListener(this);
        tvTitle.setOnClickListener(new BreakReleaseHelper());
        tvTitle.setTextColor(Styles.getColor(CustomConfig.CommonSetting.textColor));
        tvTitle.setMaxWidth(Styles.getScreenWidth(tvTitle.getContext()) / 2);
        fakeSearchPort.setOnClickListener(this);
        fakeSearchLand.setOnClickListener(this);

        updateTitleBarAccordingToSearchStatus(false);

        tvLogo = (TextView) get("aihelp_logo");
        tvLogo.setTextColor(Styles.getColorWithAlpha(CustomConfig.CommonSetting.textColor, 1f));
        tvLogo.setBackgroundColor(Styles.getColorWithAlpha(CustomConfig.CommonSetting.upperBackgroundColor, CustomConfig.CommonSetting.upperBackgroundAlpha));

        loadingAnimator = ObjectAnimator.ofFloat(ivLoading, "rotation", 0F, 360F);
        loadingAnimator.setDuration(1000);
        loadingAnimator.setInterpolator(new LinearInterpolator());
        loadingAnimator.setRepeatCount(ValueAnimator.INFINITE);

        searchView.setupSearchView(new AIHelpSearchView.OnAIHelpSearchViewListener() {
            @Override
            public void onFocusChanged() {

            }

            @Override
            public void onInputCanceled() {
                FragmentManager childFragmentManager = getChildFragmentManager();
                if (childFragmentManager.getBackStackEntryCount() > 0) {
                    childFragmentManager.popBackStack();
                }
                updateTitleBarAccordingToSearchStatus(false);
            }

        }, getFaqEventListener());

    }

    @Override
    protected int getLayout() {
        return ResResolver.getLayoutId("aihelp_fra_support");
    }

    @Override
    protected boolean isBindEventBus() {
        return true;
    }

    @Override
    public void onEventComing(EventCenter event) {

        boolean isOperatePage = false;
        Fragment topMostFragment = FragmentHelper.getTopMostFragment(getRetainedChildFragmentManager());
        if (topMostFragment != null) {
            isOperatePage = OperationFragment.class.getSimpleName().equals(topMostFragment.getClass().getSimpleName());
            if (isOperatePage) {
                tvLogo.setBackgroundColor(Styles.getColorWithAlpha(CustomConfig.CommonSetting.upperBackgroundColor, CustomConfig.CommonSetting.upperBackgroundAlpha));
            }
        }

        if (event instanceof OperatePagerEvent) {
            isOperateInHelpPage = ((OperatePagerEvent) event).getEvent();
        }

        if (event instanceof SupportActionEvent) {
            SupportActionEvent supportActionEvent = (SupportActionEvent) event;
            if (supportActionEvent.getCode() == IntentValues.SHOW_SUPPORT_ACTION) {
                msgView.setVisibility(View.VISIBLE);
                int supportAction = supportActionEvent.getSupportAction();
                switch (supportAction) {
                    case IntentValues.SUPPORT_ACTION_FAQ:
                        updateTitleBarAccordingToSearchStatus(false);
                        msgView.updateImageResource(supportAction, "aihelp_svg_ic_faq");
                        break;
                    case IntentValues.SUPPORT_ACTION_MSG:
                    case IntentValues.SUPPORT_ACTION_MSG_UNREAD:
                        if (isOperatePage && !isOperateInHelpPage) return;
                        msgView.updateImageResource(supportAction, "aihelp_svg_ic_msg_read");
                        break;
                    default:
                        msgView.setVisibility(View.GONE);
                        break;
                }
            } else {
                msgView.setVisibility(View.GONE);
            }
        }

        if (event instanceof LoadingElvaEvent) {
            if (event.getCode() == IntentValues.SHOW_CS_LOADING) {
                if (loadingAnimator.isRunning() || !shouldShowLoading(topMostFragment)) return;
                ivLoading.setVisibility(View.VISIBLE);
                loadingAnimator.start();
            } else {
                ivLoading.setVisibility(View.GONE);
                loadingAnimator.cancel();
            }
        }

        if (event instanceof PageHoppingEvent) {
            switch (event.getCode()) {
                case IntentValues.PAGE_HOPPING_CONVERSATION:
                    mSupportHelper.startConversation(getArguments(), true);
                    break;
                case IntentValues.PAGE_HOPPING_FORM:
                    mSupportHelper.onIntentToFillForm(((PageHoppingEvent) event).getEvent(), true);
                    break;
            }
        }

        if (event instanceof UpdateTitleEvent) {
            UpdateTitleEvent updateTitleEvent = (UpdateTitleEvent) event;
            if (updateTitleEvent.getIcon() != null) {
                // 只有开关打开的前提下，才可以控制 icon 的显隐
                boolean showCsTitleIcon = topMostFragment instanceof BaseCSFragment && CustomConfig.CustomerService.isCsTitleIconVisible;
                boolean showFaqTitleIcon = topMostFragment instanceof BaseFaqFragment && CustomConfig.HelpCenter.isFaqTitleIconVisible;
                Styles.loadIcon(ivTitle, updateTitleEvent.getIcon(), showCsTitleIcon || showFaqTitleIcon);
            }
            if (updateTitleEvent.getTitle() != null) {
                tvTitle.setText(updateTitleEvent.getTitle());
            }
        }

        if (event instanceof SearchViewVisibilityChangeEvent) {
            boolean shouldShowSearchView = (boolean) event.getEvent();
            updateTitleBarAccordingToSearchStatus(shouldShowSearchView);
        }

        if (event instanceof OrientationChangeEvent) {
            tvTitle.setMaxWidth(Styles.getScreenWidth(tvTitle.getContext()) / 2);
            boolean isRealSearchVisibleNow = topMostFragment instanceof FaqSearchFragment;
            updateTitleBarAccordingToSearchStatus(isRealSearchVisibleNow);
        }

        if (event instanceof FatalErrorEvent && getActivity() != null && !getActivity().isFinishing()) {
            Toast.makeText(getContext(), "Oops! Something went wrong", Toast.LENGTH_SHORT).show();

            AIHelpMqtt.getInstance().logoutMqttConnection();
            Picasso.get().shutdown();
            Const.IS_SDK_SHOWING = false;

            getActivity().finish();
        }

    }

    private boolean shouldShowLoading(Fragment topFragment) {
        if (topFragment != null) {
            String topName = topFragment.getClass().getSimpleName();
            String opName = OperationFragment.class.getSimpleName();
            String botName = ElvaBotFragment.class.getSimpleName();
            String conversationName = ConversationFragment.class.getSimpleName();
            return botName.equals(topName) || conversationName.equals(topName) || opName.equals(topName);
        }
        return false;
    }

    public boolean onBackPressed() {
        Fragment topMostFragment = FragmentHelper.getTopMostFragment(getRetainedChildFragmentManager());
        if (topMostFragment == null) return false;
        String topName = topMostFragment.getClass().getSimpleName();
        if (ElvaBotFragment.class.getSimpleName().equals(topName)) {
            return ((ElvaBotFragment) (topMostFragment)).onBackPressed();
        } else if (FaqContentFragment.class.getSimpleName().equals(topName)) {
            return ((FaqContentFragment) (topMostFragment)).onBackPressed();
        } else if (IntentUrlFragment.class.getSimpleName().equals(topName)) {
            return ((IntentUrlFragment) (topMostFragment)).onBackPressed();
        } else if (FaqSearchFragment.class.getSimpleName().equals(topName)) {
            SoftInputUtil.hideSoftInput(getContext(), searchView);
        } else if (OperationFragment.class.getSimpleName().equals(topName)) {
            return ((OperationFragment) (topMostFragment)).onBackPressed();
        }
        return true;
    }

    @Override
    public void onClick(View v) {

        if (FastClickValidator.validate(0.5f) && Const.isNestedFragmentOnResume) {
            if (v.getId() == ResResolver.getViewId("aihelp_iv_back")) {
                if (getActivity() != null) getActivity().onBackPressed();
            }

            if (v.getId() == ResResolver.getViewId("aihelp_msg_view")) {
                Bundle bundle = getArguments();
                if (bundle == null) bundle = new Bundle();

                Fragment topMostFragment = FragmentHelper.getTopMostFragment(getRetainedChildFragmentManager());
                if (topMostFragment == null) return;
                String topName = topMostFragment.getClass().getSimpleName();
                if (OperationFragment.class.getSimpleName().equals(topName)) {
                    if (isOperateInHelpPage) {
                        mSupportHelper.startConversation(bundle, true);
                    } else {
                        mSupportHelper.onIntentToSectionRoot(bundle, true);
                        StatisticHelper.whenAllFAQSectionsVisible(true);
                    }
                } else {
                    boolean skipElva = bundle.getBoolean(IntentValues.SKIP_ELVA_IN_FAQ);
                    if (ElvaBotFragment.class.getSimpleName().equals(topName) || skipElva) {
                        if (skipElva) {
                            bundle.putInt(IntentValues.SUPPORT_MODE, IntentValues.MODE_CONVERSATION);
                        }
                        mSupportHelper.startConversation(bundle, true);
                    } else {
                        mSupportHelper.startElva(bundle, true);
                    }
                }
            }

            if (v.getId() == ResResolver.getViewId("aihelp_fake_search_port") ||
                    v.getId() == ResResolver.getViewId("aihelp_fake_search_land")) {
                mSupportHelper.onIntentToSearch(getArguments());
                searchView.autoFocus();
            }
        }

    }

    private void updateTitleBarAccordingToSearchStatus(boolean showRealSearch) {

        ViewGroup viewGroup = (ViewGroup) ivTitle.getParent();
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams) viewGroup.getLayoutParams();

        Fragment topFragment = FragmentHelper.getTopMostFragment(getRetainedChildFragmentManager());
        if (topFragment instanceof BaseFaqFragment) {
            // icon 开关优先级最高，开关打开再根据 searchStatus 来控制 icon 的显隐
            ivTitle.setVisibility(CustomConfig.HelpCenter.isFaqTitleIconVisible && !showRealSearch ? View.VISIBLE : View.GONE);
            tvTitle.setVisibility(!showRealSearch ? View.VISIBLE : View.GONE);

            if (CustomConfig.HelpCenter.isFaqSearchVisible) {
                boolean isFaqHome = FaqHomeFragment.class.getName().equals(topFragment.getClass().getName());
                fakeSearchPort.setVisibility(isFaqHome && !Styles.isLandscape() && !showRealSearch ? View.VISIBLE : View.GONE);
                fakeSearchLand.setVisibility(isFaqHome && Styles.isLandscape() && !showRealSearch ? View.VISIBLE : View.GONE);
                searchView.setVisibility(showRealSearch ? View.VISIBLE : View.GONE);
            }

            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN_MR1) {
                layoutParams.addRule(RelativeLayout.END_OF, ResResolver.getViewId("aihelp_iv_back"));
                layoutParams.addRule(RelativeLayout.RIGHT_OF, ResResolver.getViewId("aihelp_iv_back"));
                viewGroup.setLayoutParams(layoutParams);
            }

            tvLogo.setBackgroundColor(topFragment instanceof FaqHomeFragment ? Color.TRANSPARENT : Styles.getColorWithAlpha(CustomConfig.CommonSetting.upperBackgroundColor, CustomConfig.CommonSetting.upperBackgroundAlpha));
        }

        if (topFragment instanceof BaseCSFragment || topFragment instanceof OperationFragment) {
            // 只有在开启了开关的前提下，才可以控制标题栏 icon 的显示
            ivTitle.setVisibility(CustomConfig.CustomerService.isCsTitleIconVisible ? View.VISIBLE : View.GONE);
            tvTitle.setVisibility(View.VISIBLE);
            fakeSearchPort.setVisibility(View.GONE);
            fakeSearchLand.setVisibility(View.GONE);
            searchView.setVisibility(View.GONE);

            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN_MR1) {
                layoutParams.removeRule(RelativeLayout.RIGHT_OF);
                layoutParams.removeRule(RelativeLayout.END_OF);
                viewGroup.setLayoutParams(layoutParams);
            }

        }

    }

    @Override
    public IFaqEventListener getFaqEventListener() {
        return mSupportHelper;
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
    }

}
