package net.aihelp.ui.adapter.cs.admin;

import android.content.Context;
import android.graphics.Color;
import android.text.TextUtils;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;

import net.aihelp.common.CustomConfig;
import net.aihelp.core.ui.adapter.ViewHolder;
import net.aihelp.core.util.concurrent.ApiExecutor;
import net.aihelp.core.util.concurrent.ApiExecutorFactory;
import net.aihelp.data.localize.data.FaqHelper;
import net.aihelp.data.model.cs.ConversationMsg;
import net.aihelp.data.model.cs.ElvaBotMsg;
import net.aihelp.data.model.faq.FaqContentEntity;
import net.aihelp.ui.adapter.cs.BaseMsgAdapter;
import net.aihelp.utils.DomainSupportHelper;
import net.aihelp.utils.FastClickValidator;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;

import androidx.appcompat.widget.AppCompatImageButton;


public class AdminFaqAdapter extends BaseMsgAdapter {

    public AdminFaqAdapter(Context context) {
        super(context);
    }

    @Override
    public int getItemViewLayoutId() {
        return ResResolver.getLayoutId("aihelp_ada_msg_faq");
    }

    @Override
    public boolean isForViewType(ConversationMsg item, int position) {
        return item.getMsgType() == ConversationMsg.TYPE_ADMIN_FAQ;
    }

    @Override
    public void convert(final ViewHolder holder, ConversationMsg s, int position) {

        if (s instanceof ElvaBotMsg) {

            final ElvaBotMsg botMsg = (ElvaBotMsg) s;
            if (botMsg.isHasUrl()) {
                String url = DomainSupportHelper.getAdjustedUrl(botMsg.getBotUrl().getUrlAddress());
                int index = TextUtils.indexOf(url, "?id=");
                if (index != -1) {
                    String faqContentId = url.substring(index + "?id=".length()).replace("&isCustom=1", "");
                    botMsg.setFaqContentId(faqContentId);
                    ApiExecutor apiExecutor = ApiExecutorFactory.getHandlerExecutor();
                    apiExecutor.runAsync(new Runnable() {
                        @Override
                        public void run() {
                            FaqContentEntity faqContentEntity = FaqHelper.INSTANCE.getFaqById(faqContentId);
                            if (faqContentEntity != null) {
                                String faqMainId = faqContentEntity.getFaqMainId();
                                botMsg.setFaqMainId(faqMainId);
                            }
                        }
                    });
                }

            }

            LinearLayout llContainer = holder.getView(getViewId("aihelp_admin_message_container"));
            llContainer.setBackground(getAdminBackgroundDrawable(isCurrentRtl));
            llContainer.removeAllViews();

            llContainer.addView(getFAQLayout(botMsg, mWrapper));

            Styles.loadIcon(holder.getView(getViewId("aihelp_iv_portrait")), CustomConfig.CustomerService.csManualSupportPortrait,
                    CustomConfig.CustomerService.isPortraitVisible, "aihelp_svg_portrait_robot");

            holder.setVisible(getViewId("aihelp_rl_helpful"), CustomConfig.CommonSetting.isEvaluationForBotEnable &&
                    botMsg.getMsgStatus() == ConversationMsg.STATUS_FAQ_NORMAL);

            AppCompatImageButton unhelpfulView = holder.getView(getViewId("aihelp_iv_faq_unhelpful"));
            Styles.reRenderImageView(unhelpfulView, "aihelp_svg_ic_un_helpful");
            unhelpfulView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    if (mWrapper != null && FastClickValidator.validate()) {
                        mWrapper.onFaqHelpfulClicked(false, botMsg);
                    }
                }
            });

            AppCompatImageButton helpfulView = holder.getView(getViewId("aihelp_iv_faq_helpful"));
            Styles.reRenderImageView(helpfulView, "aihelp_svg_ic_helpful");
            helpfulView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    if (mWrapper != null && FastClickValidator.validate()) {
                        mWrapper.onFaqHelpfulClicked(true, botMsg);
                    }
                }
            });

            LinearLayout llFeedback = holder.getView(getViewId("aihelp_ll_feedback"));
            llFeedback.setVisibility(CustomConfig.CommonSetting.isEvaluationForBotEnable &&
                    botMsg.getMsgStatus() != ConversationMsg.STATUS_FAQ_NORMAL ? View.VISIBLE : View.GONE);
            llFeedback.setBackgroundDrawable(Styles.getDrawable(Styles.getColorWithAlpha(CustomConfig.CommonSetting.upperBackgroundColor,
                    CustomConfig.CommonSetting.upperBackgroundAlpha), 8));

            // 设置感谢反馈的文案
            TextView tvThanks = holder.getView(getViewId("aihelp_tv_thanks"));
            if (botMsg.getMsgStatus() == ConversationMsg.STATUS_FAQ_UNHELPFUL || botMsg.getMsgStatus() == ConversationMsg.STATUS_FAQ_UNHELPFUL_FEEDBACK_GIVEN) {
                Styles.reRenderTextView(tvThanks, CustomConfig.CommonSetting.commonNegativeFeedbackHint, 0.35f);
            } else {
                Styles.reRenderTextView(tvThanks, CustomConfig.CommonSetting.commonPositiveFeedbackHint, 0.35f);
            }

            // 提建议按钮：
            // 1、点踩后显示，允许点击进行负反馈；
            // 2、负反馈完成后还显示，但是要置灰并且不允许点击；
            // 3、正常情况下（未评价/点赞）不显示；
            TextView tvAdvice = holder.getView(getViewId("aihelp_tv_advice"));
            tvAdvice.setText(ResResolver.getString("aihelp_faq_feedback_suggest"));
            holder.setVisible(getViewId("aihelp_tv_advice"), (CustomConfig.CommonSetting.isFaqUnhelpfulFeedbackEnable &&
                    (botMsg.getMsgStatus() == ConversationMsg.STATUS_FAQ_UNHELPFUL || botMsg.getMsgStatus() == ConversationMsg.STATUS_FAQ_UNHELPFUL_FEEDBACK_GIVEN)));
            if (botMsg.getMsgStatus() == ConversationMsg.STATUS_FAQ_UNHELPFUL) {
                tvAdvice.setEnabled(true);
                tvAdvice.setTextColor(Color.parseColor(CustomConfig.CommonSetting.interactElementTextColor));
            } else if (botMsg.getMsgStatus() == ConversationMsg.STATUS_FAQ_UNHELPFUL_FEEDBACK_GIVEN) {
                tvAdvice.setEnabled(false);
                tvAdvice.setTextColor(Color.parseColor(CustomConfig.CommonSetting.textColor));
                tvAdvice.setAlpha(0.5f);
            }
            tvAdvice.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    if (FastClickValidator.validate()) {
                        if (mWrapper != null) {
                            mWrapper.onFaqFeedbackClicked(botMsg);
                        }
                    }
                }
            });

        }

    }

}
