package net.aihelp.ui.adapter.cs.admin;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import net.aihelp.common.API;
import net.aihelp.common.Const;
import net.aihelp.common.CustomConfig;
import net.aihelp.common.UserProfile;
import net.aihelp.core.net.http.AIHelpRequest;
import net.aihelp.core.net.http.callback.ReqCallback;
import net.aihelp.core.ui.adapter.ViewHolder;
import net.aihelp.data.model.cs.ConversationMsg;
import net.aihelp.data.model.cs.ElvaBotMsg;
import net.aihelp.ui.adapter.cs.BaseMsgAdapter;
import net.aihelp.utils.DeviceUuidFactory;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;

import org.json.JSONObject;


public class AdminTextAdapter extends BaseMsgAdapter {

    public AdminTextAdapter(Context context) {
        super(context);
    }

    @Override
    public int getItemViewLayoutId() {
        return ResResolver.getLayoutId("aihelp_ada_msg_admin");
    }

    @Override
    public boolean isForViewType(ConversationMsg item, int position) {
        return item.getMsgType() == ConversationMsg.TYPE_ADMIN_TEXT;
    }

    @Override
    public void convert(ViewHolder holder, ConversationMsg s, int position) {

        LinearLayout llContainer = holder.getView(getViewId("aihelp_admin_message_container"));

        llContainer.setBackground(getAdminBackgroundDrawable(isCurrentRtl));
        llContainer.removeAllViews();

        boolean isElvaBot = s instanceof ElvaBotMsg;

        ImageView ivPortrait = holder.getView(getViewId("aihelp_iv_portrait"));
        Styles.loadIcon(
                ivPortrait,
                isElvaBot ? CustomConfig.CustomerService.csBotSupportPortrait : CustomConfig.CustomerService.csManualSupportPortrait,
                CustomConfig.CustomerService.isPortraitVisible,
                isElvaBot ? "aihelp_svg_portrait_robot" : "aihelp_svg_portrait_admin"
        );

        if (isElvaBot) {
            convertElvaBotTextMsg(llContainer, (ElvaBotMsg) s);
            holder.setVisible(getViewId("aihelp_iv_translate"), false);
        } else {
            holder.setVisible(getViewId("aihelp_iv_translate"), Const.TOGGLE_TRANSLATE_CS_MESSAGE);
            convertSupportTextMsg(holder, llContainer, s, position);
        }

    }

    private void convertSupportTextMsg(ViewHolder holder, ViewGroup container, ConversationMsg msg, int position) {

        TextView tvNickname = holder.getView(getViewId("aihelp_tv_nickname"));
        if (CustomConfig.CustomerService.isNicknameVisible && !TextUtils.isEmpty(msg.getNickname())) {
            tvNickname.setVisibility(View.VISIBLE);
            tvNickname.setText(msg.getNickname());
            tvNickname.setTextSize(13);
            tvNickname.setTextColor(Styles.getColorWithAlpha(CustomConfig.CommonSetting.textColor, 0.8));
        } else {
            tvNickname.setVisibility(View.GONE);
        }

        TextView textView = getMsg(msg.getMsgContent());
        textView.setTextColor(Color.parseColor(CustomConfig.CommonSetting.textColor));
        prepareTranslate(holder, textView, position);
        container.addView(textView);
    }

    private void convertElvaBotTextMsg(ViewGroup container, ElvaBotMsg botMsg) {
        container.addView(getMsg(botMsg.getBotMsg()));
        if (botMsg.isHasUrl()) {
            container.addView(getUrl(botMsg.getBotUrl(), mWrapper));
        }
        if (botMsg.isHasFormUrl()) {
            container.addView(getFormUrl(botMsg, mWrapper));
        }
        if (botMsg.isHasOrderInfo()) {
            container.addView(getBotOrderInfo(botMsg, mWrapper));
        }
        if (botMsg.isHasAction()) {
            for (int i = 0; i < botMsg.getActions().size(); i++) {
                container.addView(getAction(i + 1, botMsg.getActions().get(i), mWrapper));
            }
        }
    }

    private void prepareTranslate(ViewHolder holder, TextView textView, int position) {
        if (Const.TOGGLE_TRANSLATE_CS_MESSAGE) {
            int maxTextWidth = Styles.getScreenWidth(mContext) - (dip2px(mContext, 165));
            textView.setMaxWidth(maxTextWidth);
            String originContent = textView.getText().toString();
            StringBuilder translatedContent = new StringBuilder(originContent);
            holder.setOnClickListener(getViewId("aihelp_iv_translate"), new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    try {
                        JSONObject params = new JSONObject();
                        params.put("deviceId", DeviceUuidFactory.id(mContext));
                        params.put("playerId", UserProfile.USER_ID);
                        params.put("content", originContent);
                        AIHelpRequest.getInstance().requestPostByJson(API.TRANSLATE_MESSAGE, params, new ReqCallback<String>() {
                            @Override
                            public void onReqSuccess(String result) {
                                translatedContent.append("\n---------\n").append(result);
                                textView.setText(translatedContent.toString());
                                textView.setMaxWidth(Integer.MAX_VALUE);
                            }
                        });
                        holder.setVisible(getViewId("aihelp_iv_translate"), false);
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

}
