package net.aihelp.ui.adapter.cs.hint;

import android.content.Context;
import android.view.View;
import android.widget.TextView;

import net.aihelp.common.CustomConfig;
import net.aihelp.core.ui.adapter.ViewHolder;
import net.aihelp.data.model.cs.ConversationMsg;
import net.aihelp.ui.adapter.cs.BaseMsgAdapter;
import net.aihelp.utils.DateFormatUtil;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;

public class TimeMsgAdapter extends BaseMsgAdapter {

    public TimeMsgAdapter(Context context) {
        super(context);
    }

    @Override
    public int getItemViewLayoutId() {
        return ResResolver.getLayoutId("aihelp_ada_msg_hint");
    }

    @Override
    public boolean isForViewType(ConversationMsg item, int position) {
        return item.getMsgType() == ConversationMsg.TYPE_TIMESTAMP;
    }

    @Override
    public void convert(ViewHolder holder, ConversationMsg s, int position) {
        TextView tvTime = (TextView) holder.getConvertView();
        tvTime.setText(DateFormatUtil.getProperDate(mContext.getResources(), Long.parseLong(s.getMsgContent())));
        tvTime.setTextColor(Styles.getColorWithAlpha(CustomConfig.CommonSetting.textColor, 0.7f));
    }

}
