package net.aihelp.ui.faq;

import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;


import net.aihelp.common.ConfigValues;
import net.aihelp.common.Const;
import net.aihelp.common.CustomConfig;
import net.aihelp.common.IntentValues;
import net.aihelp.core.ui.BaseFragment;
import net.aihelp.core.util.bus.EventBus;
import net.aihelp.core.util.concurrent.ApiExecutorFactory;
import net.aihelp.data.event.SearchViewVisibilityChangeEvent;
import net.aihelp.data.event.LoadingElvaEvent;
import net.aihelp.data.event.SupportActionEvent;
import net.aihelp.data.event.UpdateTitleEvent;
import net.aihelp.data.logic.FaqPresenter;
import net.aihelp.data.logic.MqttCallbackImpl;
import net.aihelp.data.model.faq.FaqListEntity;
import net.aihelp.data.model.faq.FaqContentEntity;
import net.aihelp.init.AIHelpSupport;
import net.aihelp.ui.SupportFragment;
import net.aihelp.ui.cs.BaseCSFragment;
import net.aihelp.ui.cs.ElvaBotFragment;
import net.aihelp.ui.helper.FragmentHelper;
import net.aihelp.ui.helper.ResponseMqttHelper;
import net.aihelp.ui.widget.AIHelpServiceEntrance;
import net.aihelp.ui.wrapper.FaqEventListenerWrapper;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;
import net.aihelp.utils.TLog;
import net.aihelp.utils.ToastUtil;

import java.util.Iterator;
import java.util.List;

import androidx.fragment.app.Fragment;

public abstract class BaseFaqFragment<T extends FaqPresenter> extends BaseFragment<T> implements View.OnClickListener {

    protected AIHelpServiceEntrance csEntrance;

    IFaqEventListener getFaqFlowListener() {
        SupportFragment supportFragment = FragmentHelper.getSupportFragment(this);
        if (supportFragment != null) {
            return ((IFaqParentView) supportFragment).getFaqEventListener();
        }
        return new FaqEventListenerWrapper();
    }

    private String titleIcon;
    private String titleText;

    /**
     * 每个页面在创建的时候都会执行这段代码，相当于每个页面都有 currentSection 这个属性
     * 而不同页面的该字段存储的值正是当前页面所属的分类名称
     * 所以可以在 onResume 中直接将这个值 post 给 SupportFragment，即可实现正确的标题显示
     */
    @Override
    protected void getBundleBeforeDataPrepared(Bundle extras) {

        // FAQ 首页、搜索页、特定的 FAQ 分类页、单条 FAQ 页需要显示应用名称
        // 其他页面应该显示当前 FAQ 所在的分类名称和 icon
        titleIcon = extras.getString(IntentValues.SECTION_ICON);
        titleText = extras.getString(IntentValues.SECTION_NAME);

        // FAQ 首页、搜索页、特定的 FAQ 分类页、单条 FAQ 页取到的值都为空，使用默认的统一标题
        if (TextUtils.isEmpty(titleIcon)) {
            titleIcon = CustomConfig.HelpCenter.faqNavigationBarTitleIcon;
        }
        if (TextUtils.isEmpty(titleText)) {
            titleText = CustomConfig.HelpCenter.faqNavigationTitle;
        }

    }

    @Override
    public void onResume() {
        super.onResume();

        if (Const.TOGGLE_OPEN_FAQ_NOTIFICATION) {
            MqttCallbackImpl.getInstance().updateHostView(this);
        }

        EventBus.getDefault().post(new SupportActionEvent(IntentValues.HIDE_SUPPORT_ACTION));
        EventBus.getDefault().post(new LoadingElvaEvent(IntentValues.HIDE_CS_LOADING));
        EventBus.getDefault().post(new UpdateTitleEvent(UpdateTitleEvent.HELP_CENTER, titleIcon, titleText));

        // 根据 faq 搜索页面的显示隐藏状态，来变更标题栏的样式
        EventBus.getDefault().post(new SearchViewVisibilityChangeEvent(this instanceof FaqSearchFragment));

        csEntrance = get("aihelp_cs_entrance");
        if (csEntrance != null) {
            csEntrance.setup(getMergedBundle(), getFaqFlowListener());
        }

    }

    /**
     * 移除所有的 sectionId，subSectionId，faqId 等，以免造成数据混乱
     * 因为新的页面会再次对指定的 key 进行赋值操作
     *
     * @return 移除对应 key 值的干净 bundle 对象
     */
    Bundle getMergedBundle() {
        Bundle arguments = new Bundle(getArguments());
        String[] excludedKeys = new String[]{IntentValues.SECTION_ID, IntentValues.SUB_SECTION_ID, IntentValues.SECTION_ICON,
                IntentValues.FAQ_MAIN_ID};
        outer:
        for (String excludedKey : excludedKeys) {
            Iterator<String> iterator = arguments.keySet().iterator();
            while (iterator.hasNext()) {
                String bundleKey = iterator.next();
                if (excludedKey.equals(bundleKey)) {
                    iterator.remove();
                    break outer;
                }
            }
        }
        return arguments;
    }

    public void refreshList(List<FaqListEntity> displayFaqList, String section) {
        refreshList(displayFaqList);
    }

    public void refreshList(List<FaqListEntity> displayFaqList) {

    }

    public void refreshQuestionContent(FaqContentEntity faq) {

    }

    void showSearchEmpty() {
        View layout = View.inflate(getContext(), ResResolver.getLayoutId("aihelp_layout_list_empty"), null);
        ImageView imageView = layout.findViewById(ResResolver.getViewId("aihelp_iv_empty"));
        TextView textView = layout.findViewById(ResResolver.getViewId("aihelp_tv_empty"));
        Styles.reRenderImageView(imageView, "aihelp_svg_ic_empty");
        Styles.reRenderTextView(textView, ResResolver.getString("aihelp_faq_search_empty"));
        super.showEmpty(layout);
    }

    @Override
    public void showEmpty(int... layoutId) {
        View layout = View.inflate(getContext(), ResResolver.getLayoutId("aihelp_layout_list_empty"), null);
        ImageView imageView = layout.findViewById(ResResolver.getViewId("aihelp_iv_empty"));
        TextView textView = layout.findViewById(ResResolver.getViewId("aihelp_tv_empty"));
        Styles.reRenderImageView(imageView, "aihelp_svg_ic_empty");
        Styles.reRenderTextView(textView, ResResolver.getString("aihelp_data_not_found_msg"));
        super.showEmpty(layout);
    }

    public void showEntranceWithNotification(boolean hasUnreadMsg) {
        // Ensure the current page is visible before marking there is unread messages,
        // Otherwise when user chats with CS in conversation page, then come back to FAQ page,
        // there will be a new message notification which is actually not exists.
        if (isVisible()) {
            if (hasUnreadMsg) {
                ResponseMqttHelper.setHasUnreadMsg(true);
            } else {
                ResponseMqttHelper.setTicketActive(true);
            }
            if (csEntrance != null) {
                csEntrance.updateViewVisibility(getMergedBundle());
            }
        }
    }

    @Override
    public void onClick(View v) {
        if (v.getId() == ResResolver.getViewId("aihelp_cs_entrance")) {
            Bundle bundle = getArguments();
            if (bundle != null) {
                boolean skipElva = bundle.getBoolean(IntentValues.SKIP_ELVA_IN_FAQ);
                if (skipElva) {
                    // 标识 Conversation，从而保证 mqtt 可以正常断开
                    bundle.putInt(IntentValues.SUPPORT_MODE, IntentValues.MODE_CONVERSATION);
                    getFaqFlowListener().onIntentToConversation(bundle);
                } else {
                    getFaqFlowListener().onIntentToElvaBot(bundle);
                }
            }
        }
    }
}
