package net.aihelp.ui.faq;

import android.graphics.Color;
import android.os.Bundle;
import android.view.View;
import android.widget.FrameLayout;

import net.aihelp.common.ConfigValues;
import net.aihelp.common.CustomConfig;
import net.aihelp.common.IntentValues;
import net.aihelp.data.localize.data.FaqHelper;
import net.aihelp.data.logic.FaqPresenter;

import net.aihelp.data.model.faq.FaqContentEntity;
import net.aihelp.ui.helper.ResponseMqttHelper;
import net.aihelp.ui.helper.StatisticHelper;
import net.aihelp.ui.webkit.AIHelpWebChromeClient;
import net.aihelp.ui.webkit.AIHelpWebProgress;
import net.aihelp.ui.webkit.AIHelpWebView;
import net.aihelp.ui.webkit.AIHelpWebViewClient;
import net.aihelp.ui.widget.AIHelpEvaluateView;
import net.aihelp.ui.widget.AIHelpServiceEntrance;
import net.aihelp.utils.DomainSupportHelper;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;

public class FaqContentFragment extends BaseFaqFragment<FaqPresenter> {

    private AIHelpWebView mWebView;
    private AIHelpWebProgress mProgressBar;
    private AIHelpEvaluateView mEvaluateView;
    private AIHelpServiceEntrance mServiceEntrance;

    public static FaqContentFragment newInstance(Bundle bundle) {
        FaqContentFragment faqFragment = new FaqContentFragment();
        faqFragment.setArguments(bundle);
        return faqFragment;
    }

    @Override
    protected void initEventAndData(View view) {
        FrameLayout flContent = get("aihelp_ll_root");
        int colorFromHex = Styles.getColorWithAlpha(CustomConfig.CommonSetting.upperBackgroundColor,
                CustomConfig.CommonSetting.upperBackgroundAlpha);
        flContent.setBackgroundColor(colorFromHex);

        mProgressBar = get("aihelp_progress_bar");
        mEvaluateView = get("aihelp_evaluate_faq");
        mServiceEntrance = get("aihelp_cs_entrance");

        mWebView = get("aihelp_web_view");
        mWebView.setBackgroundColor(Color.TRANSPARENT);
        mWebView.setWebViewClient(new AIHelpWebViewClient(getContext(), mProgressBar, true));
        mWebView.setWebChromeClient(new AIHelpWebChromeClient(this, mProgressBar));
    }

    @Override
    public void onResume() {
        super.onResume();
        // If there are unread messages, the top-right corner should be showing a unread notification.
        // In this case, we should not try the MOMENT_ONLY_IN_ANSWER_PAGE logic at all.
        if (getArguments() != null && !ResponseMqttHelper.isHasUnreadMsg()) {
            int supportMoment = getArguments().getInt(IntentValues.FAQ_SUPPORT_MOMENT, ConfigValues.MOMENT_NEVER);
            if (supportMoment == ConfigValues.MOMENT_ONLY_IN_ANSWER_PAGE) {
                mServiceEntrance.setVisibility(View.VISIBLE);
            }
        }
    }

    @Override
    protected void getBundleAfterDataPrepared(Bundle extras) {
        String sectionId = extras.getString(IntentValues.SECTION_ID);
        String faqId = extras.getString(IntentValues.FAQ_MAIN_ID);
        String searchTerm = extras.getString(IntentValues.SEARCH_MATCH);
        mPresenter.goFetchQuestionContent(sectionId, faqId, searchTerm);
    }

    @Override
    protected int getLayout() {
        return ResResolver.getLayoutId("aihelp_fra_faq_content");
    }

    @Override
    protected int getLoadingTargetViewId() {
        return ResResolver.getViewId("aihelp_faq_content");
    }

    public void refreshQuestionContent(FaqContentEntity faq) {
        if (faq != null) {
            // 配置 EvaluateView
            mEvaluateView.setMainId(faq.getFaqMainId());
            mEvaluateView.setContentId(faq.getFaqContentId());
            if (CustomConfig.CommonSetting.isEvaluationForAnswerPageEnable && mPresenter.shouldShowQuestionFooter(faq.getFaqMainId())) {
                mEvaluateView.setEvaluateState(AIHelpEvaluateView.STATE_NORMAL);
            } else {
                mEvaluateView.setEvaluateState(AIHelpEvaluateView.STATE_INVISIBLE);
            }
            mEvaluateView.setOnAIHelpEvaluateViewCallback(new AIHelpEvaluateView.OnAIHelpEvaluateViewCallback() {
                @Override
                public void onEvaluated(boolean isHelpful) {
                    if (!isHelpful && getArguments() != null) {
                        int supportMoment = getArguments().getInt(IntentValues.FAQ_SUPPORT_MOMENT, ConfigValues.MOMENT_NEVER);
                        if (supportMoment == ConfigValues.MOMENT_AFTER_MARKING_UNHELPFUL) {
                            mServiceEntrance.setVisibility(View.VISIBLE);
                        }
                    }
                    FaqHelper.INSTANCE.afterFaqEvaluated(faq.getFaqMainId());
                }
            });

            // 设置 WebView 内容
            String faqContent = DomainSupportHelper.getAdjustedUrl(faq.getFaqContent());
            int[] colorRGB = Styles.getColorRGB(CustomConfig.CommonSetting.textColor);
            String textColor = String.format("color: rgba(%s, %s, %s, %s)", colorRGB[0], colorRGB[1], colorRGB[2], 1);
            String timeColor = String.format("color: rgba(%s, %s, %s, %s)", colorRGB[0], colorRGB[1], colorRGB[2], 0.3);
            faqContent = faqContent.replace("<body>", String.format("<body style=\"background-color: transparent; %s\">", textColor));
            faqContent = faqContent.replace("<div style='font-size:14px;color:#CCCCCC;'>", String.format("<div style='font-size:14px; %s'>", timeColor));
            mWebView.loadDataWithBaseURL(null, faqContent, "text/html",
                    "utf-8", null);

            // 记录打点
            StatisticHelper.whenFAQDetailVisible(faq.getFaqMainId(), faq.getFaqContentId());
        } else {
            showEmpty();
        }

    }

    @Override
    public void onStop() {
        super.onStop();
        mProgressBar.hide();
    }

    public boolean onBackPressed() {
        if (mWebView.canGoBack()) {
            mWebView.goBack();
            return false;
        }
        return true;
    }

}
