package net.aihelp.ui.helper;

import android.text.TextUtils;

import net.aihelp.R;
import net.aihelp.common.Const;
import net.aihelp.common.CustomConfig;
import net.aihelp.common.UserProfile;
import net.aihelp.core.net.mqtt.config.MqttConfig;
import net.aihelp.core.util.logger.AIHelpLogger;
import net.aihelp.data.localize.config.FeedbackOpinionHelper;
import net.aihelp.data.model.cs.EvaluationEntity;
import net.aihelp.data.model.cs.ConversationMsg;

import net.aihelp.db.bot.ConversationDBHelper;
import net.aihelp.utils.DeviceInfoUtil;
import net.aihelp.core.net.json.JsonHelper;
import net.aihelp.utils.TLog;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;


public class LoginMqttHelper {

    public static List<ConversationMsg> getLoginResponse(String response) {

        final ArrayList<ConversationMsg> list = new ArrayList<>();
        try {
            JSONObject loginObj = new JSONObject(response);
            if (loginObj.has("errorCode")) {
                TLog.e("mqtt login failed, " + response);
                AIHelpLogger.error("MQTT Login failed " + loginObj.toString(),
                        new UnknownError(MqttConfig.getInstance().getMqConfig()));
                return list;
            }

            // 统一处理开关配置信息
            if (loginObj.has("sdkConfig")) {
                JSONObject sdkConfig = JsonHelper.getJsonObject(loginObj, "sdkConfig");
                CustomConfig.CustomerService.isBotResolveQueryEnable = sdkConfig.optBoolean("isOpenResolveEvaluation");
                CustomConfig.CustomerService.isUnhelpfulFaqStoryNodeEnable = sdkConfig.optBoolean("enableUnhelpfulFaqStoryNode");
            }

            String msgJson = TextUtils.isEmpty(loginObj.optString("chat_private")) ? "{}" : loginObj.optString("chat_private");
            JSONObject chatHistory = new JSONObject(msgJson);

            ResponseMqttHelper.setTicketActive(chatHistory.length() > 0);
            ResponseMqttHelper.setTicketFinished(chatHistory.has("flag"));
            // 是否展示解决、未解决弹窗
            ResponseMqttHelper.setTicketWaitForAskingResolveStatus(chatHistory.has("isShowResolve"));
            // 是否展示给客服评分弹窗
            ResponseMqttHelper.setTicketWaitForRating(CustomConfig.CustomerService.isTicketRatingEnable);
            // 是否展示 「去评分」 按钮
            ResponseMqttHelper.setAppRatable("yes".equals(chatHistory.optString("storeReview")));
            // 当前否已被回绝
            ResponseMqttHelper.setTicketRejected(chatHistory.optInt("status") == 9);

            if (!TextUtils.isEmpty(Const.CUSTOM_STORY_NODE) || !Const.isLocalWelcomeAvailable) {
                if (String.valueOf(MqttConfig.TYPE_ELVA_BOT).equals(loginObj.optString("re_type"))) {
                    final JSONArray msgs = JsonHelper.getJsonArray(loginObj, "msgs");
                    switch (loginObj.optInt("contextType")) {
                        case 0: // 有机器人历史客诉
                        case 2: // 默认欢迎语
                            if (msgs.length() > 0) {
                                list.add(ElvaBotHelper.getMqttReply(JsonHelper.getJsonObject(msgs, 0).toString(), true));
                            }
                            // clear all elva message histories to avoid sending old messages to server
                            ConversationDBHelper.clearElvaMsg();
                            break;
                    }
                }
            }

            if (String.valueOf(MqttConfig.TYPE_CONVERSATION).equals(loginObj.optString("re_type"))) {
                // fill in welcome msg
                ConversationMsg defaultWelcomeMsg = new ConversationMsg(ConversationMsg.TYPE_ADMIN_TEXT, ConversationMsg.STATUS_SUCCESS);
                defaultWelcomeMsg.setTimeStamp(100);
                defaultWelcomeMsg.setMsgContent(getWelcomeMessage(loginObj.optString("vip_wlcm_msg")));
                list.add(defaultWelcomeMsg);

                // ticket history
                list.addAll(ConversationHelper.getRetrievedMsgList(chatHistory));
            }

            if (loginObj.has("evaluation")) {
                JSONObject jsonObject = new JSONObject(loginObj.optString("evaluation"));
                FeedbackOpinionHelper.INSTANCE.prepareDataSource(JsonHelper.getJsonArray(jsonObject, "detail"));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

        return list;
    }

    private static String getWelcomeMessage(String mqttWelcome) {
        if (!TextUtils.isEmpty(Const.CUSTOM_WELCOME_MSG)) {
            return Const.CUSTOM_WELCOME_MSG;
        } else if (!TextUtils.isEmpty(CustomConfig.CustomerService.csWelcomeMessage)) {
            return CustomConfig.CustomerService.csWelcomeMessage;
        } else if (!TextUtils.isEmpty(mqttWelcome)) {
            return mqttWelcome;
        } else {
            return "How can we help you ?";
        }
    }

    public static JSONObject getLoginParams() {
        JSONObject obj = new JSONObject();
        try {
            obj.put("appId", Const.APP_ID);
            obj.put("gameId", Const.APP_ID);
            obj.put("gameUid", UserProfile.USER_ID);
            obj.put("userPlayerName", UserProfile.USER_NAME);
            obj.put("userDisplayName", UserProfile.USER_NAME);
            obj.put("cmdBaseTime", Long.toString(System.currentTimeMillis()));
            obj.put("type", MqttConfig.getInstance().getLoginType());
            obj.put("gameInfo", DeviceInfoUtil.getInstance().getGameInfo());
        } catch (Exception e) {
            e.printStackTrace();
        }
        return obj;
    }

}
