package net.aihelp.ui.helper;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.text.TextUtils;

import net.aihelp.common.API;
import net.aihelp.common.Const;
import net.aihelp.common.CustomConfig;
import net.aihelp.common.UserProfile;
import net.aihelp.config.AIHelpContext;
import net.aihelp.core.net.http.AIHelpRequest;
import net.aihelp.core.net.json.JsonHelper;
import net.aihelp.data.model.init.PrivacyControlEntity;
import net.aihelp.data.model.cs.ElvaBotMsg;
import net.aihelp.ui.widget.AIHelpEvaluateView;
import net.aihelp.utils.AppInfoUtil;
import net.aihelp.utils.DeviceUuidFactory;

import org.json.JSONObject;


public class StatisticHelper {

    private static final int TRACK_TYPE_DETAIL_FAQ_OR_ARTICLE = 2;
    private static final int TRACK_TYPE_BOT_FAQ = 6;
    private static final int TRACK_TYPE_FORM_ACTION = 4;
    private static final int TRACK_TYPE_BOT_HISTORY = 11;
    private static final int TRACK_TYPE_BOT_VISIBLE = 5;
    private static final int TRACK_TYPE_BOT_SIMILAR_ANSWER = 3;
    private static final int TRACK_TYPE_SHOW_OPERATION = 21;
    private static final int TRACK_TYPE_SHOW_FAQ = 22;
    private static final int TRACK_TYPE_SEND_CLICK = 31;
    private static final int TRACK_TYPE_OP_ARTICLE_HELPFUL = 34;
    private static final int TRACK_TYPE_OP_ARTICLE_UNHELPFUL = 35;
    private static final int TRACK_TYPE_OP_ARTICLE_VISIBLE = 36;

    public static final int FORM_ACTION_DISPLAYED = 1;
    public static final int FORM_ACTION_CLICKED = 2;
    public static final int FORM_ACTION_SUBMITTED = 3;

    private static Long clickedFormTimeStamp = 0L;

    public static Long getClickedFormTimeStamp() {
        return clickedFormTimeStamp;
    }

    private static boolean isNetworkUnavailable() {
        ConnectivityManager cm = (ConnectivityManager) AIHelpContext.getInstance().getContext()
                .getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo networkInfo = null;
        if (cm != null) {
            networkInfo = cm.getActiveNetworkInfo();
        }
        return networkInfo == null || !networkInfo.isConnected();
    }

    private static <T> void get(String url, JSONObject params) {
        if (isNetworkUnavailable()) return;
        AIHelpRequest.getInstance().requestGetByAsync(url, params, null);
    }

    private static <T> void post(String url, JSONObject params) {
        if (isNetworkUnavailable()) return;
        AIHelpRequest.getInstance().requestPostByJson(url, params, null);
    }

    public static void postHelpfulStatus(int faqType, String faqContentId, boolean isHelpful) {
        try {
            if (faqType == AIHelpEvaluateView.FAQ_TYPE_OPERATE_ARTICLE) {
                JSONObject extData = new JSONObject();
                extData.put("evaluateStatus", isHelpful ? 3 : 4);
                extData.put("kmContentId", faqContentId);
                post(API.TRACK_COLLECT, getCommonParameters(isHelpful ?
                        TRACK_TYPE_OP_ARTICLE_HELPFUL : TRACK_TYPE_OP_ARTICLE_UNHELPFUL, extData));
            } else {
                JSONObject logMap = new JSONObject();
                logMap.put("id", faqContentId);
                logMap.put("type1", faqType == AIHelpEvaluateView.FAQ_TYPE_BOT_FAQ ? "15" : "4"); // 标记行为来自 faq
                logMap.put("type2", isHelpful ? "5" : "6");
                logMap.put("language", Const.CORRECT_LANGUAGE);
                post(API.LOG_COUNT_URL, logMap);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void whenOperationArticleVisible(String articleId) {
        try {
            JSONObject extData = new JSONObject();
            extData.put("type", "2");
            extData.put("id", articleId);
            extData.put("publishId", articleId);
            post(API.TRACK_COLLECT, getCommonParameters(TRACK_TYPE_DETAIL_FAQ_OR_ARTICLE, extData));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void whenOperationArticleVisibleWithCollectApi(String contentId) {
        try {
            JSONObject extData = new JSONObject();
            extData.put("evaluateStatus", 5);
            extData.put("kmContentId", contentId);
            post(API.TRACK_COLLECT, getCommonParameters(TRACK_TYPE_OP_ARTICLE_VISIBLE, extData));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    // FIXME: 2020/12/5 和机器人的 FAQ 点击统计重复
    public static void whenFAQDetailVisible(String faqMainId, String faqContentId) {
        try {
            JSONObject extData = new JSONObject();
            extData.put("type", "1");
            extData.put("publishId", faqMainId);
            extData.put("id", faqContentId);
            post(API.TRACK_COLLECT, getCommonParameters(TRACK_TYPE_DETAIL_FAQ_OR_ARTICLE, extData));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void whenBotFAQClicked(ElvaBotMsg botMsg) {
        try {
            String faqContentId = "";
            if (botMsg.isHasUrl()) {
                int index = TextUtils.indexOf(botMsg.getBotUrl().getUrlAddress(), "?id=");
                if (index != -1) {
                    faqContentId = botMsg.getBotUrl().getUrlAddress().substring(index + "?id=".length()).replace("&isCustom=1", "");
                }
            }

            JSONObject extData = new JSONObject();
            extData.put("type", "8");
            extData.put("contentId", faqContentId);
            extData.put("publishId", botMsg.getFaqMainId());
            extData.put("createTime", botMsg.getTimeStamp());
            extData.put("isClickDetail", botMsg.isFaqViewed());
            post(API.TRACK_COLLECT, getCommonParameters(TRACK_TYPE_BOT_FAQ, extData));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void whenBotFAQGotNegativeFeedback(String createTime, String contentId, String publishId) {
        try {
            JSONObject extData = new JSONObject();
            extData.put("type", "9");
            extData.put("contentId", contentId);
            extData.put("publishId", publishId);
            extData.put("createTime", createTime);
            post(API.TRACK_COLLECT, getCommonParameters(TRACK_TYPE_BOT_FAQ, extData));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void whenFormEventHappened(long createTime, int type) {
        try {
            if (FORM_ACTION_CLICKED == type) clickedFormTimeStamp = createTime;
            JSONObject extData = new JSONObject();
            extData.put("type", type);
            extData.put("createTime", createTime);
            post(API.TRACK_COLLECT, getCommonParameters(TRACK_TYPE_FORM_ACTION, extData));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void whenBotMessagePrepared(ElvaBotMsg botMsg) {
        try {
            // logElvaChatHistory
            JSONObject extData = new JSONObject();
            extData.put("message", new JSONObject(botMsg.getRawResponse()));
            extData.put("tags", JsonHelper.wrap(botMsg.getBotTagList()));
            post(API.TRACK_COLLECT, getCommonParameters(TRACK_TYPE_BOT_HISTORY, extData));

            // log similar matched message
            if (botMsg.isSimilarMatched()) {
                extData = new JSONObject();
                extData.put("message", new JSONObject(botMsg.getRawResponse()));
                extData.put("action", botMsg.getUserInput());
                post(API.TRACK_COLLECT, getCommonParameters(TRACK_TYPE_BOT_SIMILAR_ANSWER, extData));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void whenBotVisible() {
        post(API.TRACK_COLLECT, getCommonParameters(TRACK_TYPE_BOT_VISIBLE));
    }

    public static void whenAllFAQSectionsVisible(boolean isFromOperation) {
        try {
            JSONObject extendData = new JSONObject();
            extendData.put("source", isFromOperation ? 4 : 3);
            post(API.TRACK_COLLECT, getCommonParameters(TRACK_TYPE_SHOW_FAQ, extendData));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void whenOperationVisible() {
        post(API.TRACK_COLLECT, getCommonParameters(TRACK_TYPE_SHOW_OPERATION));
    }

    public static void whenSendButtonClicked() {
        post(API.TRACK_COLLECT, getCommonParameters(TRACK_TYPE_SEND_CLICK));
    }

    private static JSONObject getCommonParameters(int traceType, JSONObject... extendData) {
        JSONObject map = new JSONObject();
        try {
            map.put("trackType", traceType);
            map.put("language", Const.CORRECT_LANGUAGE);
            map.put("deviceId", DeviceUuidFactory.id(AIHelpContext.getInstance().getContext()));
            map.put("userId", UserProfile.USER_ID);

            PrivacyControlEntity entity = CustomConfig.CommonSetting.privacyControlData;
            if (entity != null && entity.getApplicationVersion()) {
                map.put("gameVersion", AppInfoUtil.getAppVersion(AIHelpContext.getInstance().getContext()));
            }
            if (entity != null && entity.getDeviceModel()) {
                map.put("deviceModel", Build.MODEL);
            }
            if (entity != null && entity.getOsVersion()) {
                map.put("osVersion", Build.VERSION.RELEASE);
            }
            if (extendData != null && extendData.length > 0) {
                map.put("extendData", extendData[0]);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

}
