package net.aihelp.ui.widget;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import net.aihelp.common.CustomConfig;
import net.aihelp.utils.Styles;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatButton;

public class AIHelpButton extends RelativeLayout {

    public AIHelpButton(@NonNull Context context) {
        this(context, null);
    }

    public AIHelpButton(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public AIHelpButton(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);

        setBackground(Styles.getDrawable(Color.parseColor(CustomConfig.CommonSetting.interactElementTextColor), 8));

        TextView textView = new TextView(context);
        RelativeLayout.LayoutParams textViewLayoutParams = new RelativeLayout.LayoutParams(
                ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT
        );
        textViewLayoutParams.addRule(RelativeLayout.CENTER_IN_PARENT);
        textView.setLayoutParams(textViewLayoutParams);

        textView.setGravity(Gravity.CENTER);
        textView.setMinWidth((int) Styles.dpToPx(context, 84));
        textView.setMinHeight((int) Styles.dpToPx(context, 28));
        textView.setBackground(Styles.getClickableDrawableForButton());
        textView.setTextColor(Color.WHITE);
        textView.setTextSize(TypedValue.COMPLEX_UNIT_SP, 15);
        textView.setMaxLines(1);
        textView.setSingleLine();
        textView.setEllipsize(TextUtils.TruncateAt.END);

        textView.setPadding(
                (int) Styles.dpToPx(context, 12),
                (int) Styles.dpToPx(context, 7),
                (int) Styles.dpToPx(context, 12),
                (int) Styles.dpToPx(context, 7)
        );

        addView(textView);
    }

    public AIHelpButton setText(String text) {
        View view = getChildAt(0);
        if (view instanceof TextView) {
            TextView textView = (TextView) view;
            textView.setText(text);
        }
        return this;
    }

    public AIHelpButton setMaxWidth(int maxWidth) {
        View view = getChildAt(0);
        if (view instanceof TextView) {
            TextView textView = (TextView) view;
            textView.setMaxWidth(maxWidth);
        }
        return this;
    }

    public AIHelpButton setFullWidth() {
        View view = getChildAt(0);
        if (view instanceof TextView) {
            TextView textView = (TextView) view;
            ViewGroup.LayoutParams layoutParams = textView.getLayoutParams();
            layoutParams.width = ViewGroup.LayoutParams.MATCH_PARENT;
            textView.setLayoutParams(layoutParams);
        }
        return this;
    }

    public String getText() {
        View view = getChildAt(0);
        if (view instanceof TextView) {
            TextView textView = (TextView) view;
            return textView.getText().toString();
        }
        return "";
    }

}
