package net.aihelp.ui.widget;

import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;

import net.aihelp.common.CustomConfig;
import net.aihelp.core.ui.image.Picasso;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;

import androidx.appcompat.widget.AppCompatImageView;
import androidx.appcompat.widget.AppCompatTextView;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

public class AIHelpFaqCardLayout extends LinearLayout {

    private final RelativeLayout rlRoot;
    private final AppCompatImageView ivTitle;
    private final AppCompatTextView tvTitle;
    private final RecyclerView rvList;

    private RecyclerView.Adapter adapter;

    public AIHelpFaqCardLayout(Context context) {
        this(context, null);
    }

    public AIHelpFaqCardLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public AIHelpFaqCardLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        View.inflate(context, ResResolver.getLayoutId("aihelp_layout_faq_card_layout"), this);

        // 设置 drawable 背景
        rlRoot = findViewById(ResResolver.getViewId("aihelp_rl_list"));
        int colorFromHex = Styles.getColorWithAlpha(CustomConfig.CommonSetting.upperBackgroundColor,
                CustomConfig.CommonSetting.upperBackgroundAlpha);
        rlRoot.setBackground(Styles.getDrawable(colorFromHex, 15));

        ivTitle = findViewById(ResResolver.getViewId("aihelp_iv_title"));

        tvTitle = findViewById(ResResolver.getViewId("aihelp_tv_title"));
        tvTitle.setTextColor(Styles.getColor(CustomConfig.CommonSetting.textColor));

        rvList = findViewById(ResResolver.getViewId("aihelp_rv_list"));

    }

    private RecyclerView.LayoutManager getLinearLayoutManager(Context context) {
        return new LinearLayoutManager(context) {
            @Override
            public boolean canScrollVertically() {
                return Styles.isLandscape();
            }
        };
    }

    private RecyclerView.LayoutManager getGridLayoutManager(Context context) {
        int spanCount = Styles.isLandscape() && !CustomConfig.HelpCenter.isFaqHotTopicVisible ? 4 : 3;
        GridLayoutManager manager = new GridLayoutManager(context, spanCount) {
            @Override
            public boolean canScrollVertically() {
                return Styles.isLandscape();
            }
        };
        if (Styles.isLandscape()) {
            manager.setSpanSizeLookup(new GridLayoutManager.SpanSizeLookup() {
                @Override
                public int getSpanSize(int position) {
                    return position == adapter.getItemCount() - 1 ? spanCount : 1;
                }
            });
        }
        return manager;
    }

    public void setup(RecyclerView.Adapter adapter) {
        setup(true, adapter);
    }

    public void setup(boolean displayAsList, RecyclerView.Adapter adapter) {
        this.adapter = adapter;

        if (displayAsList) {
            rvList.setLayoutManager(getLinearLayoutManager(getContext()));
        } else {
            rvList.setLayoutManager(getGridLayoutManager(getContext()));
        }
        int rootPadding = displayAsList ? 0 : Styles.dpToPx(getContext(), 8);
        rlRoot.setPadding(rootPadding, rlRoot.getPaddingTop(), rootPadding, rlRoot.getPaddingBottom());
        rvList.setAdapter(adapter);
    }

    public void updateTitleIcon(boolean visible, String iconUrl) {
        if (visible && !TextUtils.isEmpty(iconUrl)) {
            ivTitle.setVisibility(View.VISIBLE);
            Picasso.get().load(iconUrl).into(ivTitle);
        }
    }

    public void updateTitleText(boolean visible, String title) {
        if (visible && !TextUtils.isEmpty(title)) {
            tvTitle.setVisibility(View.VISIBLE);
            Styles.reRenderTextView(tvTitle, title);
        }
    }


}
