package net.aihelp.ui.widget;

import android.content.Context;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.View;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import net.aihelp.common.CustomConfig;
import net.aihelp.core.util.bus.EventBus;
import net.aihelp.core.util.bus.Subscribe;
import net.aihelp.core.util.bus.ThreadMode;
import net.aihelp.core.util.bus.event.EventCenter;
import net.aihelp.data.event.NetErrorEvent;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.SoftInputUtil;
import net.aihelp.utils.Styles;

import androidx.annotation.Nullable;

public class AIHelpSearchView extends LinearLayout {

    private boolean isSearchSessionOpen;
    private final EditText editText;
    private final TextView tvCancel;

    private OnAIHelpSearchViewListener mListener;

    public void setupSearchView(OnAIHelpSearchViewListener listener, TextWatcher watcher) {
        this.mListener = listener;
        if (editText != null) {
            if (watcher != null) editText.addTextChangedListener(watcher);
        }
    }

    public AIHelpSearchView(Context context) {
        this(context, null);
    }

    public AIHelpSearchView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public AIHelpSearchView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);

        View.inflate(context, ResResolver.getLayoutId("aihelp_layout_search_view"), this);

        View searchContainer = findViewById(ResResolver.getViewId("aihelp_ll_search"));
        searchContainer.setBackground(Styles.getDrawable(Styles.getColorWithAlpha(CustomConfig.CommonSetting.textColor,
                0.1f), 999));

        ImageView imageView = findViewById(ResResolver.getViewId("aihelp_iv_search"));
        Styles.reRenderImageView(imageView, "aihelp_svg_ic_search_grey",
                Styles.getColorWithAlpha(CustomConfig.CommonSetting.textColor, 0.5f));

        editText = findViewById(ResResolver.getViewId("aihelp_et_search"));
        Styles.reRenderTextView(editText, CustomConfig.HelpCenter.faqSearchHint);

        tvCancel = findViewById(ResResolver.getViewId("aihelp_tv_cancel_search"));
        Styles.reRenderTextView(tvCancel, ResResolver.getString("aihelp_no"), Styles.getColor(CustomConfig.CommonSetting.interactElementTextColor));
        editText.setOnFocusChangeListener(new View.OnFocusChangeListener() {
            @Override
            public void onFocusChange(View v, boolean hasFocus) {
                if (!isSearchSessionOpen && hasFocus) {
                    tvCancel.setVisibility(View.VISIBLE);
                    isSearchSessionOpen = true;
                    if (mListener != null) {
                        mListener.onFocusChanged();
                    }
                }
            }
        });
        tvCancel.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                clearInputFocus();
            }
        });
    }

    private void clearInputFocus() {
        tvCancel.setVisibility(View.GONE);
        editText.setText("");
        editText.clearFocus();

        if (getContext() != null) {
            SoftInputUtil.hideSoftInput(getContext(), editText);
        }

        if (mListener != null) {
            mListener.onInputCanceled();
        }

        isSearchSessionOpen = false;
    }

    public void autoFocus() {
        editText.setText("");
        editText.requestFocus();
        if (getContext() != null) {
            SoftInputUtil.showSoftInput(getContext(), editText);
        }
    }

    public interface OnAIHelpSearchViewListener {
        void onFocusChanged();

        void onInputCanceled();
    }

}
