package net.aihelp.utils;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Build;
import android.text.TextUtils;
import android.util.DisplayMetrics;

import net.aihelp.common.Const;
import net.aihelp.common.SpKeys;
import net.aihelp.config.AIHelpContext;

import java.util.Locale;

import androidx.annotation.RestrictTo;

@RestrictTo(RestrictTo.Scope.LIBRARY)
public class LocaleUtil {

    public static Locale getLocale() {
        Context aiHelpContext = AIHelpContext.getInstance().getContext();
        if (aiHelpContext != null) {
            Resources resources = aiHelpContext.getResources();
            Configuration configuration = resources.getConfiguration();
            return Build.VERSION.SDK_INT >= 24 ? configuration.getLocales().get(0) : configuration.locale;
        }
        return Locale.getDefault();
    }

    public static void updateLocale(Locale locale) {
        Context aiHelpContext = AIHelpContext.getInstance().getContext();
        if (aiHelpContext != null) {
            Resources resources = aiHelpContext.getResources();
            DisplayMetrics displayMetrics = resources.getDisplayMetrics();
            Configuration configuration = resources.getConfiguration();
            configuration.locale = locale;
            resources.updateConfiguration(configuration, displayMetrics);
        }
    }

    public static String getSDKLanguage() {
        String sdkLanguage = SpUtil.getInstance().getString(SpKeys.SDK_LANGUAGE);
        return TextUtils.isEmpty(sdkLanguage) ? "" : sdkLanguage;
    }

    public static Locale getCurrentLocale(String language) {
        Locale locale;
        if (TextUtils.isEmpty(language)) {
            locale = Locale.getDefault();
        } else if (language.contains("-")) {
            String[] languageArray = language.split("-");
            locale = new Locale(languageArray[0], languageArray[1]);
        } else {
            locale = new Locale(language);
        }
        return locale;
    }

    //得到矫正后的语言
    public static String getFormatLanguage(String language) {
        if (TextUtils.isEmpty(language)) {
            language = "en";
        } else if (language.equalsIgnoreCase("in_id")
                || language.equalsIgnoreCase("in")
                || language.equalsIgnoreCase("id")) {
            language = "id";//针对印尼语做的特殊处理
        } else if (language.equalsIgnoreCase("zh")) {
            language = "zh-CN";
        }
        return filterSymbol(language);
    }

    //过滤符号
    private static String filterSymbol(String language) {
        String tempLanguage = "en";
        if (!TextUtils.isEmpty(language)) {
            tempLanguage = language;
            if (tempLanguage.contains("_")) {//针对下横适配成中横
                tempLanguage = tempLanguage.replace("_", "-");
            }
            if (tempLanguage.contains("#")) {//针对#过滤
                tempLanguage = tempLanguage.replace("#", "");
            }
        }
        return tempLanguage;
    }

}
