package net.aihelp.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;

import androidx.annotation.RestrictTo;

@RestrictTo(RestrictTo.Scope.LIBRARY)
public class URLEncodeUtil {

    public static String encode(String paramString) {
        if (paramString == null || paramString.equals("")) {
            return "";
        }
        try {
            String str = null;
            if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.KITKAT) {
                str = new String(paramString.getBytes(), StandardCharsets.UTF_8);
            }
            str = URLEncoder.encode(str, "UTF-8");
            return str;
        } catch (Exception localException) {
        }
        return "";
    }

    public static String decode(String paramString) {
        if (paramString == null || paramString.equals("")) {
            return "";
        }
        try {
            String url = null;
            if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.KITKAT) {
                url = new String(paramString.getBytes(), StandardCharsets.UTF_8);
            }
            url = URLDecoder.decode(url, "UTF-8");
            return url;
        } catch (Exception e) {
            e.printStackTrace();
            return paramString;
        }
    }

}
