/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.config;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Build;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import net.aihelp.utils.LocaleUtil;

public class AIHelpContext {
    private Context context;
    private static final Object lock = new Object();
    public static AtomicBoolean successfullyInit = new AtomicBoolean(false);
    @SuppressLint(value={"StaticFieldLeak"})
    private static AIHelpContext INSTANCE;

    private AIHelpContext() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AIHelpContext getInstance() {
        if (INSTANCE == null) {
            Object object = lock;
            synchronized (object) {
                if (INSTANCE == null) {
                    INSTANCE = new AIHelpContext();
                }
            }
        }
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContext(Context c) {
        Object object = lock;
        synchronized (object) {
            this.context = c;
        }
    }

    public Context getContext() {
        return this.context;
    }

    public static Context createContextWithLocale(Context context, String language) {
        if (Build.VERSION.SDK_INT >= 17) {
            Locale locale = LocaleUtil.getCurrentLocale(language);
            Resources res = context.getResources();
            Configuration config = new Configuration(res.getConfiguration());
            config.setLocale(locale);
            Context newContext = context.createConfigurationContext(config);
            if (newContext != null) {
                return newContext;
            }
            config.locale = locale;
            res.updateConfiguration(config, res.getDisplayMetrics());
            return context;
        }
        return context;
    }

    public static Context getLocaleUpdatedContext(Context context, String language) {
        Locale locale = LocaleUtil.getCurrentLocale(language);
        Resources res = context.getResources();
        Configuration config = new Configuration(res.getConfiguration());
        config.locale = locale;
        res.updateConfiguration(config, res.getDisplayMetrics());
        return context;
    }
}

