/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.config;

import net.aihelp.config.enums.ConversationIntent;

public class ConversationConfig {
    private int conversationIntent;
    private boolean alwaysShowHumanSupportButtonInBotPage;
    private String welcomeMessage;
    private String storyNode;

    public int getConversationIntent() {
        return this.conversationIntent;
    }

    public boolean isAlwaysShowHumanSupportButtonInBotPage() {
        return this.alwaysShowHumanSupportButtonInBotPage;
    }

    public String getWelcomeMessage() {
        return this.welcomeMessage;
    }

    public String getStoryNode() {
        return this.storyNode;
    }

    private ConversationConfig(int conversationIntent, boolean alwaysShowHumanSupportButtonInBotPage, String welcomeMessage, String storyNode) {
        this.conversationIntent = conversationIntent;
        this.alwaysShowHumanSupportButtonInBotPage = alwaysShowHumanSupportButtonInBotPage;
        this.welcomeMessage = welcomeMessage;
        this.storyNode = storyNode;
    }

    public String toString() {
        return "SupportConfig{supportIntent=" + this.conversationIntent + ", alwaysShowHumanSupportButtonInBotPage=" + this.alwaysShowHumanSupportButtonInBotPage + ", welcomeMessage='" + this.welcomeMessage + '\'' + '}';
    }

    public static class Builder {
        private int conversationIntent = ConversationIntent.BOT_SUPPORT.getValue();
        private boolean alwaysShowHumanSupportButtonInBotPage;
        private String welcomeMessage;
        private String storyNode;

        public Builder setConversationIntent(ConversationIntent conversationIntent) {
            this.conversationIntent = conversationIntent.getValue();
            return this;
        }

        public Builder setAlwaysShowHumanSupportButtonInBotPage(boolean alwaysShowHumanSupportButtonInBotPage) {
            this.alwaysShowHumanSupportButtonInBotPage = alwaysShowHumanSupportButtonInBotPage;
            return this;
        }

        public Builder setWelcomeMessage(String welcomeMessage) {
            this.welcomeMessage = welcomeMessage;
            return this;
        }

        public Builder setStoryNode(String storyNode) {
            this.storyNode = storyNode;
            return this;
        }

        public ConversationConfig build(int supportIntent, boolean contactUsAlwaysOnline, String welcomeMessage, String storyNode) {
            return new ConversationConfig(supportIntent, contactUsAlwaysOnline, welcomeMessage, storyNode);
        }

        public ConversationConfig build() {
            return new ConversationConfig(this.conversationIntent, this.alwaysShowHumanSupportButtonInBotPage, this.welcomeMessage, this.storyNode);
        }
    }
}

