/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.config;

import android.text.TextUtils;
import java.util.Arrays;
import java.util.Iterator;
import net.aihelp.common.UserProfile;
import net.aihelp.config.enums.PushPlatform;
import org.json.JSONObject;

public class UserConfig {
    private String userId;
    private String userName;
    private String serverId;
    private String userTags;
    private String formatCustomData;
    private boolean isSyncCrmInfo;
    private String pushToken;
    private PushPlatform pushPlatform;

    public boolean isSyncCrmInfo() {
        return this.isSyncCrmInfo;
    }

    public String getUserId() {
        if (TextUtils.isEmpty((CharSequence)this.userId)) {
            return UserProfile.USER_ID;
        }
        return this.userId;
    }

    public String getUserName() {
        if (TextUtils.isEmpty((CharSequence)this.userName)) {
            return UserProfile.USER_NAME;
        }
        return this.userName;
    }

    public String getServerId() {
        if (TextUtils.isEmpty((CharSequence)this.serverId)) {
            return UserProfile.SERVER_ID;
        }
        return this.serverId;
    }

    public String getUserTags() {
        return this.userTags;
    }

    public String getFormatCustomData() {
        if (TextUtils.isEmpty((CharSequence)this.formatCustomData)) {
            return UserProfile.CUSTOM_DATA;
        }
        return this.formatCustomData;
    }

    public String getPushToken() {
        return this.pushToken;
    }

    public PushPlatform getPushPlatform() {
        return this.pushPlatform;
    }

    private UserConfig(String userId, String userName, String serverId, String userTags, String formatCustomData, boolean isSyncCrmInfo) {
        this.userId = userId;
        this.userName = userName;
        this.serverId = serverId;
        this.userTags = userTags;
        this.formatCustomData = formatCustomData;
        this.isSyncCrmInfo = isSyncCrmInfo;
    }

    private UserConfig(String userId, String userName, String serverId, String userTags, String formatCustomData, boolean isSyncCrmInfo, String pushToken, PushPlatform pushPlatform) {
        this.userId = userId;
        this.userName = userName;
        this.serverId = serverId;
        this.userTags = userTags;
        this.formatCustomData = formatCustomData;
        this.isSyncCrmInfo = isSyncCrmInfo;
        this.pushToken = pushToken;
        this.pushPlatform = pushPlatform;
    }

    public String toString() {
        return "UserConfig{userId='" + this.userId + '\'' + ", userName='" + this.userName + '\'' + ", serverId='" + this.serverId + '\'' + ", userTags='" + this.userTags + '\'' + ", formatCustomData='" + this.formatCustomData + '\'' + ", isSyncCrmInfo=" + this.isSyncCrmInfo + '}';
    }

    public static class Builder {
        private String userId = "";
        private String userName = "";
        private String serverId = "";
        private String userTags = "";
        private String customData = "";
        private boolean isSyncCrmInfo;
        private String pushToken = "";
        private PushPlatform pushPlatform = PushPlatform.FIREBASE;

        public Builder setUserId(String userId) {
            if (!(TextUtils.isEmpty((CharSequence)userId) || "0".equals(userId) || "-1".equals(userId))) {
                this.userId = userId.trim().replace("/", "%2F").replace("+", "%2B").replace("#", "%23").replace(" ", "%20").replace("|", "%7C");
            }
            return this;
        }

        public Builder setUserName(String userName) {
            if (!TextUtils.isEmpty((CharSequence)userName)) {
                this.userName = userName;
            }
            return this;
        }

        public Builder setServerId(String serverId) {
            if (!(TextUtils.isEmpty((CharSequence)serverId) || "0".equals(serverId) || "-1".equals(serverId))) {
                this.serverId = serverId;
            }
            return this;
        }

        public Builder setUserTags(String userTags) {
            if (!TextUtils.isEmpty((CharSequence)userTags)) {
                this.userTags = userTags;
            }
            return this;
        }

        public Builder setCustomData(String customDataJsonString) {
            if (!TextUtils.isEmpty((CharSequence)customDataJsonString)) {
                this.customData = customDataJsonString;
            }
            return this;
        }

        public Builder setSyncCrmInfo(boolean syncCrmInfo) {
            this.isSyncCrmInfo = syncCrmInfo;
            return this;
        }

        public Builder setPushToken(String pushToken) {
            this.pushToken = pushToken;
            return this;
        }

        public Builder setPushPlatform(PushPlatform pushPlatform) {
            this.pushPlatform = pushPlatform;
            return this;
        }

        private String getFormattedCustomData() {
            JSONObject returnData = new JSONObject();
            try {
                String[] userTagsArray;
                JSONObject jsonObject = new JSONObject();
                if (!TextUtils.isEmpty((CharSequence)this.userTags) && (userTagsArray = this.userTags.trim().split(",")).length > 0) {
                    jsonObject.put("elva-tags", Arrays.asList(userTagsArray));
                    jsonObject.put("hs-tags", (Object)this.userTags);
                }
                try {
                    if (!TextUtils.isEmpty((CharSequence)this.customData)) {
                        JSONObject customJsonObject = new JSONObject(this.customData);
                        Iterator keys = customJsonObject.keys();
                        while (keys.hasNext()) {
                            String key = (String)keys.next();
                            jsonObject.put(key, customJsonObject.opt(key));
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                returnData.put("elva-custom-metadata", (Object)jsonObject);
                returnData.put("hs-custom-metadata", (Object)new JSONObject(jsonObject.toString()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return returnData.toString();
        }

        public UserConfig build(String userId, String userName, String serverId, String userTags, String customData, boolean isSyncCrmInfo) {
            return this.setUserId(userId).setUserName(userName).setServerId(serverId).setUserTags(userTags).setCustomData(customData).setSyncCrmInfo(isSyncCrmInfo).build();
        }

        public UserConfig build(String userId, String userName, String serverId, String userTags, String customData, boolean isSyncCrmInfo, String pushToken, PushPlatform pushPlatform) {
            return this.setUserId(userId).setUserName(userName).setServerId(serverId).setUserTags(userTags).setCustomData(customData).setSyncCrmInfo(isSyncCrmInfo).setPushToken(pushToken).setPushPlatform(pushPlatform).build();
        }

        public UserConfig build() {
            return new UserConfig(this.userId, this.userName, this.serverId, this.userTags, this.getFormattedCustomData(), this.isSyncCrmInfo, this.pushToken, this.pushPlatform);
        }
    }
}

