/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.net.check;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aihelp.core.net.check.Task;

public final class TraceRoute
implements Task {
    private static final int MaxHop = 21;
    private static final String Error = "network error";
    private static final String MATCH_TRACE_IP = "(?<=From )(?:[0-9]{1,3}\\.){3}[0-9]{1,3}";
    private static final String MATCH_TRACE_IP_V6 = "(?<=From )\\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])(\\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])(\\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])(\\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])(\\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])(\\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])(\\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])(\\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])){3}))|:)))(%.+)?\\s*";
    private static final String MATCH_PING_IP = "(?<=from ).*(?=: icmp_seq=1 ttl=)";
    private static final String MATCH_PING_TIME = "(?<=time=).*?ms";
    private final String address;
    private final Callback complete;
    private volatile boolean stopped = false;
    private Result result = null;

    private TraceRoute(String address, Callback complete) {
        this.address = address;
        this.complete = complete;
    }

    static Matcher traceMatcher(String str, boolean isIpv6) {
        if (isIpv6) {
            Pattern patternTrace = Pattern.compile(MATCH_TRACE_IP_V6);
            return patternTrace.matcher(str);
        }
        Pattern patternTrace = Pattern.compile(MATCH_TRACE_IP);
        return patternTrace.matcher(str);
    }

    static Matcher timeMatcher(String str) {
        Pattern patternTime = Pattern.compile(MATCH_PING_TIME);
        return patternTime.matcher(str);
    }

    static Matcher ipMatcher(String str) {
        Pattern patternIp = Pattern.compile(MATCH_PING_IP);
        return patternIp.matcher(str);
    }

    static String getIpFromTraceMatcher(Matcher m) {
        String pingIp = m.group();
        int start = pingIp.indexOf(40);
        if (start >= 0) {
            pingIp = pingIp.substring(start + 1);
        }
        return pingIp;
    }

    public static Task start(String address, Callback complete) {
        final TraceRoute t = new TraceRoute(address, complete);
        new Thread(new Runnable(){

            @Override
            public void run() {
                t.run();
            }
        }).start();
        return t;
    }

    private static String getIp(String host) throws UnknownHostException {
        InetAddress i = InetAddress.getByName(host);
        return i.getHostAddress();
    }

    @Override
    public void stop() {
        this.stopped = true;
    }

    private Process executePingCmd(String host, int hop, boolean isIpv6) throws IOException {
        String command = "ping -n -c 1 -t " + hop + " " + host;
        if (isIpv6) {
            command = "ping6 -n -c 1 -t " + hop + " " + host;
        }
        return Runtime.getRuntime().exec(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPingtOutput(Process process) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        StringBuilder text = new StringBuilder();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                text.append(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            process.waitFor();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        process.destroy();
        return text.toString();
    }

    private void printNormal(Matcher m, long time, StringBuilder lineBuffer) {
        String pingIp = TraceRoute.getIpFromTraceMatcher(m);
        lineBuffer.append("\t");
        lineBuffer.append(pingIp);
        lineBuffer.append("\t\t");
        lineBuffer.append(time);
        lineBuffer.append("ms\t");
        this.result.append(lineBuffer.toString());
    }

    private void printEnd(Matcher m, String out, StringBuilder lineBuffer) {
        String pingIp = m.group();
        Matcher matcherTime = TraceRoute.timeMatcher(out);
        if (matcherTime.find()) {
            String time = matcherTime.group();
            lineBuffer.append("\t\t");
            lineBuffer.append(pingIp);
            lineBuffer.append("\t\t");
            lineBuffer.append(time);
            lineBuffer.append("\t");
            this.updateOut(lineBuffer.toString());
        }
    }

    private void updateOut(String str) {
        if (this.result != null && str != null) {
            this.result.append(str);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void run() {
        int hop = 1;
        String ip = null;
        try {
            ip = TraceRoute.getIp(this.address);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            this.updateOut("unknown host " + this.address);
            this.result = new Result("");
            this.complete.complete(this.result);
            return;
        }
        boolean isIpv6 = false;
        try {
            InetAddress address = InetAddress.getByName(ip);
            if (address instanceof Inet6Address) {
                isIpv6 = true;
            } else if (!(address instanceof Inet4Address)) {
                // empty if block
            }
        }
        catch (Exception address) {
            // empty catch block
        }
        this.result = new Result(ip);
        this.result.append(String.format("TraceRoute host address is %s. \n", this.address));
        while (hop < 21 && !this.stopped) {
            Process p;
            long t1 = System.currentTimeMillis();
            try {
                p = this.executePingCmd(ip, hop, isIpv6);
            }
            catch (IOException e) {
                e.printStackTrace();
                this.updateOut("ping cmd error " + e.getMessage());
                break;
            }
            long t2 = System.currentTimeMillis();
            String str = this.getPingtOutput(p);
            if (str.length() == 0) {
                this.updateOut(Error);
                break;
            }
            Matcher m = TraceRoute.traceMatcher(str, isIpv6);
            StringBuilder lineBuffer = new StringBuilder(256);
            lineBuffer.append(hop).append(".");
            if (m.find()) {
                this.printNormal(m, (t2 - t1) / 2L, lineBuffer);
            } else {
                Matcher matchPingIp = TraceRoute.ipMatcher(str);
                if (matchPingIp.find()) {
                    this.printEnd(matchPingIp, str, lineBuffer);
                    break;
                }
                lineBuffer.append("\t\t * \t");
                this.updateOut(lineBuffer.toString());
            }
            ++hop;
        }
        this.complete.complete(this.result);
    }

    public static class Result {
        public final String ip;
        private final StringBuilder builder = new StringBuilder();
        private String allData;

        public Result(String ip) {
            this.ip = ip;
        }

        public String content() {
            if (this.allData != null) {
                return this.allData;
            }
            this.allData = this.builder.toString();
            return this.allData;
        }

        private void append(String str) {
            this.builder.append(str);
        }
    }

    public static interface Callback {
        public void complete(Result var1);
    }
}

