/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.net.http;

import android.os.Looper;
import android.text.TextUtils;
import java.io.File;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.regex.Pattern;
import net.aihelp.common.API;
import net.aihelp.core.net.http.callback.AIHelpCallback;
import net.aihelp.core.net.http.callback.BaseCallback;
import net.aihelp.core.net.http.callback.DownloadCallback;
import net.aihelp.core.net.http.callback.UploadCallback;
import net.aihelp.core.net.http.config.HttpConfig;
import net.aihelp.core.util.concurrent.ApiExecutor;
import net.aihelp.core.util.concurrent.ApiExecutorFactory;
import net.aihelp.data.localize.util.LocalizeUtil;
import net.aihelp.utils.TLog;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.json.JSONObject;

public class AIHelpRequest {
    private static final String ENCODE = "utf-8";
    private OkHttpClient mOkHttpClient = HttpConfig.getOkHttpClient(true);

    private AIHelpRequest() {
    }

    public static AIHelpRequest getInstance() {
        return Holder.INSTANCE;
    }

    public <T> void requestGetByAsync(String actionUrl, BaseCallback<T> callBack) {
        this.requestGetByAsync(actionUrl, null, callBack);
    }

    public <T> void requestGetByAsync(String actionUrl, JSONObject jsonObject, BaseCallback<T> callBack) {
        if (!TextUtils.isEmpty((CharSequence)actionUrl)) {
            if (!actionUrl.contains("//")) {
                actionUrl = API.REQUEST_SCHEME + API.HOST_URL + actionUrl;
            }
            StringBuilder tempParams = new StringBuilder();
            try {
                int pos = 0;
                if (jsonObject != null) {
                    Iterator keys = jsonObject.keys();
                    while (keys.hasNext()) {
                        String key = (String)keys.next();
                        if (pos > 0) {
                            tempParams.append("&");
                        }
                        tempParams.append(String.format("%s=%s", key, URLEncoder.encode(jsonObject.optString(key), ENCODE)));
                        ++pos;
                    }
                }
                if (!TextUtils.isEmpty((CharSequence)tempParams)) {
                    actionUrl = String.format("%s?%s", actionUrl, tempParams.toString());
                }
                Request request = new Request.Builder().url(actionUrl).build();
                Call call = this.mOkHttpClient.newCall(request);
                this.onRequest(callBack, call);
            }
            catch (Exception e) {
                TLog.e("AIHelpRequest requestGetByAsync catch Exception: " + e.toString());
                this.failedCallBack(actionUrl, e.getMessage(), callBack);
            }
        }
    }

    public <T> Call requestPostByJson(String actionUrl, JSONObject json, BaseCallback<T> callBack) {
        if (!TextUtils.isEmpty((CharSequence)actionUrl)) {
            try {
                if (!actionUrl.contains("//")) {
                    actionUrl = API.REQUEST_SCHEME + API.HOST_URL + actionUrl;
                }
                if (json == null) {
                    json = new JSONObject();
                }
                RequestBody body = RequestBody.create((MediaType)HttpConfig.MEDIA_TYPE_JSON, (String)json.toString());
                Request request = new Request.Builder().url(actionUrl).post(body).build();
                Call call = this.mOkHttpClient.newCall(request);
                return this.onRequest(callBack, call);
            }
            catch (Exception e) {
                TLog.e("AIHelpRequest requestPostByAsync catch Exception: " + e.toString());
                this.failedCallBack(actionUrl, e.getMessage(), callBack);
            }
        }
        return null;
    }

    public <T> Call requestUpLoadFile(String actionUrl, File targetFile, UploadCallback callBack) {
        Request request;
        if (!actionUrl.contains("//")) {
            actionUrl = API.REQUEST_SCHEME + API.HOST_URL + actionUrl;
        }
        if ((request = HttpConfig.getUploadRequest(actionUrl, targetFile)) == null) {
            this.failedCallBack(actionUrl, "", callBack);
            return null;
        }
        Call call = HttpConfig.getOkHttpClient(false).newCall(request);
        return this.onRequest(callBack, call);
    }

    public <T> void requestDownloadFile(int mode, BaseCallback<T> callBack) {
        String url = LocalizeUtil.getUrl(mode);
        if (!TextUtils.isEmpty((CharSequence)url) && LocalizeUtil.isFallbackUrl(mode, url)) {
            this.failedCallBack(url, "The cdn file is not working, requesting data via API.", callBack);
        } else if (!LocalizeUtil.isAlreadyLocalized(mode)) {
            if (!TextUtils.isEmpty((CharSequence)url)) {
                TLog.e(String.format("LocalizeUrl: %s", url));
            }
            if (Pattern.compile(".+\\.(json|aiml)").matcher(url).matches()) {
                Request request = new Request.Builder().url(url).build();
                Call call = this.mOkHttpClient.newCall(request);
                call.enqueue(new DownloadCallback<T>(callBack, LocalizeUtil.getFileLocation(mode)));
            }
        } else {
            TLog.e(String.format("FilePath: %s", LocalizeUtil.getFileLocation(mode)));
            this.successCallBack(callBack);
        }
    }

    public void requestDownloadFile(String url, String path, BaseCallback callBack) {
        Request request = new Request.Builder().url(url).build();
        Call call = this.mOkHttpClient.newCall(request);
        call.enqueue(new DownloadCallback(callBack, path));
    }

    private <T> Call onRequest(BaseCallback<T> callBack, Call call) {
        call.enqueue(new AIHelpCallback<T>(callBack));
        return call;
    }

    private <T> void successCallBack(final BaseCallback<T> callBack) {
        if (callBack == null) {
            return;
        }
        ApiExecutor apiExecutor = ApiExecutorFactory.getHandlerExecutor();
        if (Looper.getMainLooper().getThread() == Thread.currentThread()) {
            apiExecutor.runAsync(new Runnable(){

                @Override
                public void run() {
                    callBack.onAsyncReqSuccess(null);
                }
            });
            callBack.onReqSuccess(null);
        } else {
            callBack.onAsyncReqSuccess(null);
            apiExecutor.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    callBack.onReqSuccess(null);
                }
            });
        }
    }

    private <T> void failedCallBack(final String url, final String errorMsg, final BaseCallback<T> callBack) {
        if (callBack == null) {
            return;
        }
        callBack.onAsyncFailure(url, -1, errorMsg);
        ApiExecutor apiExecutor = ApiExecutorFactory.getHandlerExecutor();
        apiExecutor.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                callBack.onFailure(url, -1, errorMsg);
            }
        });
    }

    private static class Holder {
        private static final AIHelpRequest INSTANCE = new AIHelpRequest();

        private Holder() {
        }
    }
}

