/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.net.http.callback;

import androidx.annotation.NonNull;
import java.io.IOException;
import net.aihelp.core.net.http.callback.BaseCallback;
import net.aihelp.core.net.http.pojo.ResultEntity;
import net.aihelp.core.net.json.JsonHelper;
import net.aihelp.core.util.concurrent.ApiExecutor;
import net.aihelp.core.util.concurrent.ApiExecutorFactory;
import net.aihelp.core.util.logger.AIHelpLogger;
import net.aihelp.utils.TLog;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Request;
import okhttp3.Response;

public class AIHelpCallback<T>
implements Callback {
    private final BaseCallback<T> reqCallBack;

    public AIHelpCallback(BaseCallback<T> reqCallBack) {
        this.reqCallBack = reqCallBack;
    }

    public void onFailure(@NonNull Call call, @NonNull IOException e) {
        TLog.e("AIHelpCallback onFailure: " + e.toString());
        String requestUrl = call.request().url().toString();
        this.failedCallBack(call.request(), requestUrl, -1, e.toString(), this.reqCallBack);
        AIHelpLogger.error(requestUrl, e);
    }

    public void onResponse(@NonNull Call call, @NonNull Response response) {
        if (this.reqCallBack == null) {
            return;
        }
        String requestUrl = call.request().url().toString();
        try {
            if (response.isSuccessful() && response.body() != null) {
                String string = response.body().string();
                if (this.isUniqueRequest(call, string)) {
                    return;
                }
                ResultEntity result = JsonHelper.toJavaObject(string, ResultEntity.class);
                if (null != result) {
                    if (result.isFlag()) {
                        String data = result.getData();
                        if (null == data || data.equals("")) {
                            this.successCallBack(null, this.reqCallBack);
                        } else if (this.reqCallBack.getType() == String.class || this.reqCallBack.getType() == Integer.class || this.reqCallBack.getType() == Double.class || this.reqCallBack.getType() == Float.class) {
                            this.successCallBack(data, this.reqCallBack);
                        } else {
                            this.successCallBack(JsonHelper.toJavaObject(data, this.reqCallBack.getType()), this.reqCallBack);
                        }
                    } else {
                        this.failedCallBack(call.request(), requestUrl, 200, result.getDesc(), this.reqCallBack);
                    }
                } else {
                    this.failedCallBack(call.request(), requestUrl, -1, "ResultEntity is NULL", this.reqCallBack);
                }
            } else {
                this.failedCallBack(call.request(), requestUrl, response.code(), response.message(), this.reqCallBack);
            }
        }
        catch (Throwable e) {
            TLog.e("AIHelpCallback onResponse catch Exception: " + e.toString());
            this.failedCallBack(call.request(), requestUrl, -1, e.toString(), this.reqCallBack);
            AIHelpLogger.error(requestUrl, e);
        }
    }

    private void successCallBack(final T result, final BaseCallback<T> callBack) {
        if (callBack == null) {
            return;
        }
        callBack.onAsyncReqSuccess(result);
        ApiExecutor apiExecutor = ApiExecutorFactory.getHandlerExecutor();
        apiExecutor.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                callBack.onReqSuccess(result);
            }
        });
    }

    private void failedCallBack(Request request, final String url, final int errorCode, final String errorMsg, final BaseCallback<T> callBack) {
        if (callBack == null) {
            return;
        }
        callBack.onAsyncFailure(url, errorCode, errorMsg);
        ApiExecutor apiExecutor = ApiExecutorFactory.getHandlerExecutor();
        apiExecutor.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                callBack.onFailure(url, errorCode, errorMsg);
            }
        });
    }

    private boolean isUniqueRequest(Call call, String string) {
        String requestUrl = call.request().url().toString();
        if (requestUrl.contains("initset") || requestUrl.contains("getfaqfilenames") || requestUrl.contains("upload") || requestUrl.contains("faqs") || requestUrl.contains("crmtoken") || requestUrl.contains("sdkconfig") || requestUrl.contains("collect") || requestUrl.endsWith(".json")) {
            this.successCallBack(JsonHelper.toJavaObject(string, this.reqCallBack.getType()), this.reqCallBack);
            return true;
        }
        return false;
    }
}

