/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.net.http.callback;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import net.aihelp.core.net.http.callback.BaseCallback;
import net.aihelp.core.util.concurrent.ApiExecutor;
import net.aihelp.core.util.concurrent.ApiExecutorFactory;
import net.aihelp.core.util.logger.AIHelpLogger;
import net.aihelp.utils.TLog;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;

public class DownloadCallback<T>
implements Callback {
    private static final String TAG = "RequestManager";
    private final BaseCallback<T> reqCallBack;
    private final String targetPath;

    public DownloadCallback(BaseCallback<T> reqCallBack, String targetPath) {
        this.reqCallBack = reqCallBack;
        this.targetPath = targetPath;
    }

    public void onFailure(@NonNull Call call, @NonNull IOException e) {
        TLog.e(TAG, "DownloadCallback onFailure: " + e.toString());
        String requestUrl = call.request().url().toString();
        this.failedCallBack(requestUrl, e.getMessage(), this.reqCallBack);
        AIHelpLogger.error(requestUrl, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onResponse(@NonNull Call call, @NonNull Response response) {
        String requestUrl = call.request().url().toString();
        if (TextUtils.isEmpty((CharSequence)this.targetPath)) {
            return;
        }
        if (response.body() == null || !response.isSuccessful()) {
            this.failedCallBack(requestUrl, "", this.reqCallBack);
            return;
        }
        File file = new File(this.targetPath);
        InputStream input = null;
        FileOutputStream output = null;
        try {
            int bytesRead;
            input = response.body().byteStream();
            output = new FileOutputStream(file);
            byte[] buffer = new byte[8192];
            while ((bytesRead = input.read(buffer, 0, buffer.length)) >= 0) {
                output.write(buffer, 0, bytesRead);
            }
            this.successCallBack(this.reqCallBack);
            this.closeQuietly(input);
            this.closeQuietly(output);
        }
        catch (Throwable e) {
            try {
                TLog.e(TAG, "DownloadCallback onResponse catch Exception: " + e.toString());
                this.failedCallBack(requestUrl, e.getMessage(), this.reqCallBack);
                AIHelpLogger.error(requestUrl, e);
                this.closeQuietly(input);
                this.closeQuietly(output);
            }
            catch (Throwable throwable) {
                this.closeQuietly(input);
                this.closeQuietly(output);
                throw throwable;
            }
        }
    }

    private void successCallBack(final BaseCallback<T> callBack) {
        if (callBack == null) {
            return;
        }
        callBack.onAsyncReqSuccess(null);
        ApiExecutor apiExecutor = ApiExecutorFactory.getHandlerExecutor();
        apiExecutor.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                callBack.onReqSuccess(null);
            }
        });
    }

    private void failedCallBack(final String url, final String errorMsg, final BaseCallback<T> callBack) {
        if (callBack == null) {
            return;
        }
        callBack.onAsyncFailure(url, -1, errorMsg);
        ApiExecutor apiExecutor = ApiExecutorFactory.getHandlerExecutor();
        apiExecutor.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                callBack.onFailure(url, -1, errorMsg);
            }
        });
    }

    private void closeQuietly(Closeable stream) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

