/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.net.mqtt;

import android.os.Handler;
import android.os.Message;
import androidx.annotation.NonNull;
import net.aihelp.core.net.mqtt.callback.ConnectCallback;
import net.aihelp.core.net.mqtt.callback.IMqttCallback;
import net.aihelp.core.net.mqtt.callback.ReceiveListener;
import net.aihelp.core.net.mqtt.callback.SendCallback;
import net.aihelp.core.net.mqtt.callback.SubscribeCallback;
import net.aihelp.core.net.mqtt.client.Callback;
import net.aihelp.core.net.mqtt.client.CallbackConnection;
import net.aihelp.core.net.mqtt.client.QoS;
import net.aihelp.core.net.mqtt.config.MqttConfig;
import net.aihelp.core.util.logger.AIHelpLogger;
import net.aihelp.ui.helper.LoginMqttHelper;
import net.aihelp.utils.TLog;
import org.json.JSONObject;

public class AIHelpMqtt {
    private int connectionId;
    private CallbackConnection mqttConnection;
    private CallbackConnection faqMqttConnection;
    private static ConnectingHandler mConnectingMonitor;

    public int getMqttConnectionId() {
        return this.connectionId;
    }

    public void prepare(int type, IMqttCallback callback) {
        boolean isFaqRequest;
        boolean bl = isFaqRequest = type == 3;
        if (!isFaqRequest) {
            MqttConfig.getInstance().setLoginType(type);
        }
        if (MqttConfig.getInstance().isConnected()) {
            if (type == 2) {
                this.postToServer("login", LoginMqttHelper.getLoginParams());
                return;
            }
            callback.dismissMqttLoading();
            return;
        }
        mConnectingMonitor.sendEmptyMessageDelayed(0, 5000L);
        ++this.connectionId;
        this.mqttConnection = MqttConfig.getInstance().getMqttConnection(isFaqRequest, this.connectionId);
        this.mqttConnection.connect(new ConnectCallback(isFaqRequest, callback, this.connectionId));
        this.mqttConnection.listener(new ReceiveListener(isFaqRequest, callback, mConnectingMonitor, this.connectionId));
        this.mqttConnection.subscribe(MqttConfig.getInstance().getTopic(isFaqRequest), new SubscribeCallback(isFaqRequest, callback, this.connectionId));
        if (isFaqRequest) {
            this.faqMqttConnection = this.mqttConnection;
        }
    }

    public void postToServer(String topicName, JSONObject params) {
        try {
            if (this.mqttConnection != null) {
                String topic = MqttConfig.newTopic(topicName);
                byte[] bytes = params.toString().getBytes();
                TLog.json(String.format("MQTT [send message] %s", topicName), new String(bytes));
                this.mqttConnection.publish(topic, bytes, QoS.AT_MOST_ONCE, false, (Callback<Void>)new SendCallback());
            }
        }
        catch (Exception e) {
            TLog.e("MQTT postToServer error -> " + e.toString());
        }
    }

    public void onFaqDestroy() {
        if (this.faqMqttConnection != null) {
            this.faqMqttConnection.disconnect(null);
            this.faqMqttConnection = null;
        }
    }

    public void logoutMqttConnection() {
        if (this.mqttConnection != null && this.mqttConnection.getIdentifier() == this.connectionId) {
            this.mqttConnection.unregisterListener();
            this.mqttConnection.disconnect(null);
            this.mqttConnection = null;
        }
        MqttConfig.getInstance().setConnected(false);
    }

    public static AIHelpMqtt getInstance() {
        return Holder.INSTANCE;
    }

    private AIHelpMqtt() {
        mConnectingMonitor = new ConnectingHandler();
    }

    public static class ConnectingHandler
    extends Handler {
        public void handleMessage(@NonNull Message msg) {
            JSONObject loginParams = LoginMqttHelper.getLoginParams();
            AIHelpLogger.error(String.format("mqtt[%s] connect for more than 5s.", MqttConfig.getInstance().getMqConfig()), new IllegalStateException(loginParams.toString()));
        }
    }

    private static class Holder {
        private static final AIHelpMqtt INSTANCE = new AIHelpMqtt();

        private Holder() {
        }
    }
}

