/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.net.mqtt.client;

import net.aihelp.core.net.mqtt.client.Callback;
import net.aihelp.core.net.mqtt.client.Promise;
import net.aihelp.core.net.mqtt.hawtbuf.Buffer;
import net.aihelp.core.net.mqtt.hawtbuf.UTF8Buffer;
import net.aihelp.core.net.mqtt.hawtdispatch.DispatchQueue;
import net.aihelp.core.net.mqtt.hawtdispatch.Task;

public class Message {
    private final UTF8Buffer topic;
    private final Buffer payload;
    private Callback<Callback<Void>> onComplete;
    private final DispatchQueue queue;
    boolean blocking = false;

    public Message(DispatchQueue queue, UTF8Buffer topic, Buffer payload, Callback<Callback<Void>> onComplete) {
        this.queue = queue;
        this.payload = payload;
        this.topic = topic;
        this.onComplete = onComplete;
    }

    public byte[] getPayload() {
        return this.payload.toByteArray();
    }

    public Buffer getPayloadBuffer() {
        return this.payload;
    }

    public String getTopic() {
        return this.topic.toString();
    }

    public UTF8Buffer getTopicBuffer() {
        return this.topic;
    }

    public void ack() {
        if (this.blocking) {
            Promise<Void> future = new Promise<Void>();
            this.ack(future);
            try {
                future.await();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            this.ack(null);
        }
    }

    public void ack(final Callback<Void> onAcked) {
        if (this.onComplete != null) {
            this.queue.execute(new Task(){
                Callback<Callback<Void>> onCompleteCopy;
                {
                    this.onCompleteCopy = Message.this.onComplete;
                }

                @Override
                public void run() {
                    this.onCompleteCopy.onSuccess(onAcked);
                }
            });
            this.onComplete = null;
        } else if (onAcked != null) {
            onAcked.onSuccess(null);
        }
    }
}

