/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.net.mqtt.codec;

import java.io.IOException;
import java.net.ProtocolException;
import net.aihelp.core.net.mqtt.client.QoS;
import net.aihelp.core.net.mqtt.codec.MQTTFrame;
import net.aihelp.core.net.mqtt.codec.MessageSupport;
import net.aihelp.core.net.mqtt.hawtbuf.DataByteArrayInputStream;
import net.aihelp.core.net.mqtt.hawtbuf.DataByteArrayOutputStream;
import net.aihelp.core.net.mqtt.hawtbuf.UTF8Buffer;

public class CONNECT
implements MessageSupport.Message {
    public static final byte TYPE = 1;
    private static final UTF8Buffer V3_PROTOCOL_NAME = new UTF8Buffer("MQIsdp");
    private static final UTF8Buffer V4_PROTOCOL_NAME = new UTF8Buffer("MQTT");
    private short keepAlive = (short)30;
    private UTF8Buffer clientId;
    private UTF8Buffer willTopic;
    private UTF8Buffer willMessage = new UTF8Buffer("");
    private boolean willRetain;
    private byte willQos;
    private boolean cleanSession = true;
    private UTF8Buffer userName;
    private UTF8Buffer password;
    private int version = 3;

    public CONNECT() {
    }

    public CONNECT(CONNECT other) {
        this.keepAlive = other.keepAlive;
        this.clientId = other.clientId;
        this.willTopic = other.willTopic;
        this.willMessage = other.willMessage;
        this.willRetain = other.willRetain;
        this.willQos = other.willQos;
        this.cleanSession = other.cleanSession;
        this.userName = other.userName;
        this.password = other.password;
        this.version = other.version;
    }

    @Override
    public byte messageType() {
        return 1;
    }

    @Override
    public CONNECT decode(MQTTFrame frame) throws ProtocolException {
        byte flags;
        DataByteArrayInputStream is = new DataByteArrayInputStream(frame.buffers[0]);
        UTF8Buffer protocolName = MessageSupport.readUTF(is);
        if (V4_PROTOCOL_NAME.equals(protocolName)) {
            this.version = is.readByte() & 0xFF;
            if (this.version < 4) {
                throw new ProtocolException("Invalid CONNECT frame: protocol name/version mismatch");
            }
        } else if (V3_PROTOCOL_NAME.equals(protocolName)) {
            this.version = is.readByte() & 0xFF;
            if (this.version != 3) {
                throw new ProtocolException("Invalid CONNECT frame: protocol name/version mismatch");
            }
        } else {
            throw new ProtocolException("Invalid CONNECT frame");
        }
        boolean username_flag = ((flags = is.readByte()) & 0x80) > 0;
        boolean password_flag = (flags & 0x40) > 0;
        this.willRetain = (flags & 0x20) > 0;
        this.willQos = (byte)((flags & 0x18) >>> 3);
        boolean will_flag = (flags & 4) > 0;
        this.cleanSession = (flags & 2) > 0;
        this.keepAlive = is.readShort();
        this.clientId = MessageSupport.readUTF(is);
        if (this.clientId.length == 0) {
            this.clientId = null;
        }
        if (will_flag) {
            this.willTopic = MessageSupport.readUTF(is);
            this.willMessage = MessageSupport.readUTF(is);
        }
        if (username_flag) {
            this.userName = MessageSupport.readUTF(is);
        }
        if (password_flag) {
            this.password = MessageSupport.readUTF(is);
        }
        return this;
    }

    @Override
    public MQTTFrame encode() {
        try {
            if (!(this.clientId != null && this.clientId.length != 0 || this.cleanSession)) {
                throw new IllegalArgumentException("A clean session must be used when no clientId is specified");
            }
            DataByteArrayOutputStream os = new DataByteArrayOutputStream(500);
            if (this.version == 3) {
                MessageSupport.writeUTF(os, V3_PROTOCOL_NAME);
                os.writeByte(this.version);
            } else if (this.version >= 4) {
                MessageSupport.writeUTF(os, V4_PROTOCOL_NAME);
                os.writeByte(this.version);
            } else {
                throw new IllegalArgumentException("Invalid version: " + this.version);
            }
            int flags = 0;
            if (this.userName != null) {
                flags |= 0x80;
            }
            if (this.password != null) {
                flags |= 0x40;
            }
            if (this.willTopic != null && this.willMessage != null) {
                flags |= 4;
                if (this.willRetain) {
                    flags |= 0x20;
                }
                flags |= this.willQos << 3 & 0x18;
            }
            if (this.cleanSession) {
                flags |= 2;
            }
            os.writeByte(flags);
            os.writeShort(this.keepAlive);
            MessageSupport.writeUTF(os, this.clientId);
            if (this.willTopic != null && this.willMessage != null) {
                MessageSupport.writeUTF(os, this.willTopic);
                MessageSupport.writeUTF(os, this.willMessage);
            }
            if (this.userName != null) {
                MessageSupport.writeUTF(os, this.userName);
            }
            if (this.password != null) {
                MessageSupport.writeUTF(os, this.password);
            }
            MQTTFrame frame = new MQTTFrame();
            frame.commandType(1);
            return frame.buffer(os.toBuffer());
        }
        catch (IOException e) {
            throw new RuntimeException("The impossible happened");
        }
    }

    public boolean cleanSession() {
        return this.cleanSession;
    }

    public CONNECT cleanSession(boolean cleanSession) {
        this.cleanSession = cleanSession;
        return this;
    }

    public UTF8Buffer clientId() {
        return this.clientId;
    }

    public CONNECT clientId(UTF8Buffer clientId) {
        this.clientId = clientId;
        return this;
    }

    public short keepAlive() {
        return this.keepAlive;
    }

    public CONNECT keepAlive(short keepAlive) {
        this.keepAlive = keepAlive;
        return this;
    }

    public UTF8Buffer password() {
        return this.password;
    }

    public CONNECT password(UTF8Buffer password) {
        this.password = password;
        return this;
    }

    public UTF8Buffer userName() {
        return this.userName;
    }

    public CONNECT userName(UTF8Buffer userName) {
        this.userName = userName;
        return this;
    }

    public UTF8Buffer willMessage() {
        return this.willMessage;
    }

    public CONNECT willMessage(UTF8Buffer willMessage) {
        this.willMessage = willMessage;
        return this;
    }

    public QoS willQos() {
        return QoS.values()[this.willQos];
    }

    public CONNECT willQos(QoS willQos) {
        this.willQos = (byte)willQos.ordinal();
        return this;
    }

    public boolean willRetain() {
        return this.willRetain;
    }

    public CONNECT willRetain(boolean willRetain) {
        this.willRetain = willRetain;
        return this;
    }

    public UTF8Buffer willTopic() {
        return this.willTopic;
    }

    public CONNECT willTopic(UTF8Buffer willTopic) {
        this.willTopic = willTopic;
        return this;
    }

    public int version() {
        return this.version;
    }

    public CONNECT version(int version) {
        if (version == 3) {
            this.version = version;
        } else if (version >= 4) {
            this.version = version;
        } else {
            throw new IllegalArgumentException("Invalid version: " + version);
        }
        return this;
    }

    public String toString() {
        return "CONNECT{cleanSession=" + this.cleanSession + ", keepAlive=" + this.keepAlive + ", clientId=" + this.clientId + ", willTopic=" + this.willTopic + ", willMessage=" + this.willMessage + ", willRetain=" + this.willRetain + ", willQos=" + this.willQos + ", userName=" + this.userName + ", password=" + this.password + '}';
    }
}

