/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.net.mqtt.hawtdispatch;

import java.util.LinkedList;
import java.util.concurrent.Executor;
import net.aihelp.core.net.mqtt.hawtdispatch.CustomDispatchSource;
import net.aihelp.core.net.mqtt.hawtdispatch.Dispatch;
import net.aihelp.core.net.mqtt.hawtdispatch.DispatchQueue;
import net.aihelp.core.net.mqtt.hawtdispatch.EventAggregators;
import net.aihelp.core.net.mqtt.hawtdispatch.Task;
import net.aihelp.core.net.mqtt.hawtdispatch.TaskWrapper;

public class AggregatingExecutor
implements Executor {
    final DispatchQueue queue;
    final CustomDispatchSource<Runnable, LinkedList<Runnable>> source;

    public AggregatingExecutor(DispatchQueue queue) {
        this.queue = queue;
        this.source = Dispatch.createSource(EventAggregators.linkedList(), queue);
        this.source.setEventHandler(new Task(){

            @Override
            public void run() {
                for (Runnable runnable : AggregatingExecutor.this.source.getData()) {
                    try {
                        runnable.run();
                    }
                    catch (Exception e) {
                        Thread thread = Thread.currentThread();
                        thread.getUncaughtExceptionHandler().uncaughtException(thread, e);
                    }
                }
            }
        });
        this.source.resume();
    }

    public void suspend() {
        this.source.suspend();
    }

    public void resume() {
        this.source.resume();
    }

    @Override
    public void execute(Runnable task) {
        if (Dispatch.getCurrentQueue() == null) {
            this.queue.execute(new TaskWrapper(task));
        } else {
            this.source.merge(task);
        }
    }
}

