/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.net.mqtt.tansport;

import java.util.concurrent.TimeUnit;
import net.aihelp.core.net.mqtt.hawtdispatch.Dispatch;
import net.aihelp.core.net.mqtt.hawtdispatch.Task;
import net.aihelp.core.net.mqtt.tansport.ProtocolCodec;
import net.aihelp.core.net.mqtt.tansport.Transport;

public class HeartBeatMonitor {
    Transport transport;
    long initialWriteCheckDelay;
    long initialReadCheckDelay;
    long writeInterval;
    long readInterval;
    Task onKeepAlive = Dispatch.NOOP;
    Task onDead = Dispatch.NOOP;
    volatile short session = 0;
    boolean readSuspendedInterval;
    short readSuspendCount;
    Object lock = new Object();

    public void suspendRead() {
        this.readSuspendCount = (short)(this.readSuspendCount + 1);
        this.readSuspendedInterval = true;
    }

    public void resumeRead() {
        this.readSuspendCount = (short)(this.readSuspendCount - 1);
    }

    private void schedule(final short session, long interval, final Task func) {
        if (this.session == session) {
            this.transport.getDispatchQueue().executeAfter(interval, TimeUnit.MILLISECONDS, new Task(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = HeartBeatMonitor.this.lock;
                    synchronized (object) {
                        if (HeartBeatMonitor.this.session == session) {
                            func.run();
                        }
                    }
                }
            });
        }
    }

    private void scheduleCheckWrites(final short session) {
        Task func;
        final ProtocolCodec codec = this.transport.getProtocolCodec();
        if (codec == null) {
            func = new Task(){

                @Override
                public void run() {
                    HeartBeatMonitor.this.scheduleCheckWrites(session);
                }
            };
        } else {
            final long lastWriteCounter = codec.getWriteCounter();
            func = new Task(){

                @Override
                public void run() {
                    if (lastWriteCounter == codec.getWriteCounter()) {
                        HeartBeatMonitor.this.onKeepAlive.run();
                    }
                    HeartBeatMonitor.this.scheduleCheckWrites(session);
                }
            };
        }
        this.schedule(session, this.writeInterval, func);
    }

    private void scheduleCheckReads(final short session) {
        Task func;
        final ProtocolCodec codec = this.transport.getProtocolCodec();
        if (codec == null) {
            func = new Task(){

                @Override
                public void run() {
                    HeartBeatMonitor.this.scheduleCheckReads(session);
                }
            };
        } else {
            final long lastReadCounter = codec.getReadCounter();
            func = new Task(){

                @Override
                public void run() {
                    if (lastReadCounter == codec.getReadCounter() && !HeartBeatMonitor.this.readSuspendedInterval && HeartBeatMonitor.this.readSuspendCount == 0) {
                        HeartBeatMonitor.this.onDead.run();
                    }
                    HeartBeatMonitor.this.readSuspendedInterval = false;
                    HeartBeatMonitor.this.scheduleCheckReads(session);
                }
            };
        }
        this.schedule(session, this.readInterval, func);
    }

    public void start() {
        this.session = (short)(this.session + 1);
        this.readSuspendedInterval = false;
        if (this.writeInterval != 0L) {
            if (this.initialWriteCheckDelay != 0L) {
                this.transport.getDispatchQueue().executeAfter(this.initialWriteCheckDelay, TimeUnit.MILLISECONDS, new Task(){

                    @Override
                    public void run() {
                        HeartBeatMonitor.this.scheduleCheckWrites(HeartBeatMonitor.this.session);
                    }
                });
            } else {
                this.scheduleCheckWrites(this.session);
            }
        }
        if (this.readInterval != 0L) {
            if (this.initialReadCheckDelay != 0L) {
                this.transport.getDispatchQueue().executeAfter(this.initialReadCheckDelay, TimeUnit.MILLISECONDS, new Task(){

                    @Override
                    public void run() {
                        HeartBeatMonitor.this.scheduleCheckReads(HeartBeatMonitor.this.session);
                    }
                });
            } else {
                this.scheduleCheckReads(this.session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            this.session = (short)(this.session + 1);
        }
    }

    public long getInitialReadCheckDelay() {
        return this.initialReadCheckDelay;
    }

    public void setInitialReadCheckDelay(long initialReadCheckDelay) {
        this.initialReadCheckDelay = initialReadCheckDelay;
    }

    public long getInitialWriteCheckDelay() {
        return this.initialWriteCheckDelay;
    }

    public void setInitialWriteCheckDelay(long initialWriteCheckDelay) {
        this.initialWriteCheckDelay = initialWriteCheckDelay;
    }

    public Task getOnDead() {
        return this.onDead;
    }

    public void setOnDead(Task onDead) {
        this.onDead = onDead;
    }

    public Task getOnKeepAlive() {
        return this.onKeepAlive;
    }

    public void setOnKeepAlive(Task onKeepAlive) {
        this.onKeepAlive = onKeepAlive;
    }

    public long getWriteInterval() {
        return this.writeInterval;
    }

    public void setWriteInterval(long writeInterval) {
        this.writeInterval = writeInterval;
    }

    public Transport getTransport() {
        return this.transport;
    }

    public void setTransport(Transport transport) {
        this.transport = transport;
    }

    public long getReadInterval() {
        return this.readInterval;
    }

    public void setReadInterval(long readInterval) {
        this.readInterval = readInterval;
    }
}

