/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.net.mqtt.tansport;

import java.net.InetSocketAddress;
import java.util.LinkedList;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import net.aihelp.core.net.mqtt.hawtdispatch.CustomDispatchSource;
import net.aihelp.core.net.mqtt.hawtdispatch.Dispatch;
import net.aihelp.core.net.mqtt.hawtdispatch.DispatchQueue;
import net.aihelp.core.net.mqtt.hawtdispatch.EventAggregators;
import net.aihelp.core.net.mqtt.hawtdispatch.Task;
import net.aihelp.core.net.mqtt.hawtdispatch.TaskWrapper;
import net.aihelp.core.net.mqtt.tansport.PipeTransport;
import net.aihelp.core.net.mqtt.tansport.PipeTransportRegistry;
import net.aihelp.core.net.mqtt.tansport.TransportServer;
import net.aihelp.core.net.mqtt.tansport.TransportServerListener;

public class PipeTransportServer
implements TransportServer {
    protected String connectURI;
    protected TransportServerListener listener;
    protected String name;
    protected boolean marshal;
    protected final AtomicInteger connectionCounter = new AtomicInteger();
    DispatchQueue dispatchQueue;
    private CustomDispatchSource<PipeTransport, LinkedList<PipeTransport>> acceptSource;

    @Override
    public String getBoundAddress() {
        return this.connectURI;
    }

    @Override
    public InetSocketAddress getSocketAddress() {
        return null;
    }

    @Override
    public DispatchQueue getDispatchQueue() {
        return this.dispatchQueue;
    }

    @Override
    public void setDispatchQueue(DispatchQueue queue) {
        this.dispatchQueue = queue;
    }

    @Override
    public void suspend() {
        this.acceptSource.suspend();
    }

    @Override
    public void resume() {
        this.acceptSource.resume();
    }

    @Override
    public void setTransportServerListener(TransportServerListener listener) {
        this.listener = listener;
    }

    @Override
    @Deprecated
    public void start(Runnable onCompleted) throws Exception {
        this.start(new TaskWrapper(onCompleted));
    }

    @Override
    @Deprecated
    public void stop(Runnable onCompleted) throws Exception {
        this.stop(new TaskWrapper(onCompleted));
    }

    @Override
    public void start(Task onCompleted) throws Exception {
        this.acceptSource = Dispatch.createSource(EventAggregators.linkedList(), this.dispatchQueue);
        this.acceptSource.setEventHandler(new Task(){

            @Override
            public void run() {
                LinkedList transports = (LinkedList)PipeTransportServer.this.acceptSource.getData();
                for (PipeTransport transport : transports) {
                    try {
                        PipeTransportServer.this.listener.onAccept(transport);
                    }
                    catch (Exception e) {
                        PipeTransportServer.this.listener.onAcceptError(e);
                    }
                }
            }
        });
        this.acceptSource.resume();
        if (onCompleted != null) {
            this.dispatchQueue.execute(onCompleted);
        }
    }

    @Override
    public void stop(Task onCompleted) throws Exception {
        PipeTransportRegistry.unbind(this);
        this.acceptSource.setCancelHandler(onCompleted);
        this.acceptSource.cancel();
    }

    public void setConnectURI(String connectURI) {
        this.connectURI = connectURI;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public PipeTransport connect() {
        PipeTransport serverTransport;
        int connectionId = this.connectionCounter.incrementAndGet();
        String remoteAddress = this.connectURI.toString() + "#" + connectionId;
        PipeTransport clientTransport = this.createClientTransport();
        clientTransport.peer = serverTransport = this.createServerTransport();
        serverTransport.peer = clientTransport;
        clientTransport.setRemoteAddress(remoteAddress);
        serverTransport.setRemoteAddress(remoteAddress);
        serverTransport.setMarshal(this.marshal);
        this.acceptSource.merge(serverTransport);
        return clientTransport;
    }

    protected PipeTransport createClientTransport() {
        return new PipeTransport(this);
    }

    protected PipeTransport createServerTransport() {
        return new PipeTransport(this);
    }

    public boolean isMarshal() {
        return this.marshal;
    }

    public void setMarshal(boolean marshal) {
        this.marshal = marshal;
    }

    @Override
    public Executor getBlockingExecutor() {
        return null;
    }

    @Override
    public void setBlockingExecutor(Executor blockingExecutor) {
    }
}

