/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.ui.adapter;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.aihelp.core.ui.adapter.ItemViewDelegate;
import net.aihelp.core.ui.adapter.ItemViewDelegateManager;
import net.aihelp.core.ui.adapter.ViewHolder;

public class MultiItemTypeAdapter<T>
extends RecyclerView.Adapter<ViewHolder> {
    protected Context mContext;
    protected List<T> mDatas = new ArrayList<T>();
    protected ItemViewDelegateManager<T> mItemViewDelegateManager;
    protected OnItemClickListener mOnItemClickListener;

    public MultiItemTypeAdapter(Context mContext) {
        this.mContext = mContext;
        this.mItemViewDelegateManager = new ItemViewDelegateManager();
    }

    public int getItemViewType(int position) {
        if (!this.useItemViewDelegateManager()) {
            return super.getItemViewType(position);
        }
        return this.mItemViewDelegateManager.getItemViewType(this.mDatas.get(position), position);
    }

    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        ItemViewDelegate itemViewDelegate = this.mItemViewDelegateManager.getItemViewDelegate(viewType);
        int layoutId = itemViewDelegate.getItemViewLayoutId();
        ViewHolder holder = ViewHolder.createViewHolder(this.mContext, parent, layoutId);
        this.onViewHolderCreated(holder, holder.getConvertView());
        this.setListener(parent, holder, viewType);
        return holder;
    }

    public void onViewHolderCreated(ViewHolder holder, View itemView) {
    }

    public void convert(ViewHolder holder, T t) {
        this.mItemViewDelegateManager.convert(holder, t, holder.getAdapterPosition());
    }

    protected boolean isEnabled(int viewType) {
        return true;
    }

    protected void setListener(ViewGroup parent, final ViewHolder viewHolder, int viewType) {
        if (!this.isEnabled(viewType)) {
            return;
        }
        viewHolder.getConvertView().setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (MultiItemTypeAdapter.this.mOnItemClickListener != null) {
                    int position = viewHolder.getAdapterPosition();
                    MultiItemTypeAdapter.this.mOnItemClickListener.onItemClick(v, viewHolder, position);
                }
            }
        });
        viewHolder.getConvertView().setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                if (MultiItemTypeAdapter.this.mOnItemClickListener != null) {
                    int position = viewHolder.getAdapterPosition();
                    return MultiItemTypeAdapter.this.mOnItemClickListener.onItemLongClick(v, viewHolder, position);
                }
                return false;
            }
        });
    }

    public void onBindViewHolder(ViewHolder holder, int position) {
        this.convert(holder, this.mDatas.get(position));
    }

    public int getItemCount() {
        int itemCount = this.mDatas.size();
        return itemCount;
    }

    protected void addItemViewDelegate(ItemViewDelegate<T> itemViewDelegate) {
        this.mItemViewDelegateManager.addDelegate(itemViewDelegate);
    }

    protected MultiItemTypeAdapter addItemViewDelegate(int viewType, ItemViewDelegate<T> itemViewDelegate) {
        this.mItemViewDelegateManager.addDelegate(viewType, itemViewDelegate);
        return this;
    }

    protected MultiItemTypeAdapter removeItemViewDelegate(int viewType) {
        this.mItemViewDelegateManager.removeDelegate(viewType);
        return this;
    }

    private boolean useItemViewDelegateManager() {
        return this.mItemViewDelegateManager.getItemViewDelegateCount() > 0;
    }

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        this.mOnItemClickListener = onItemClickListener;
    }

    public void update(List<T> dataList, Boolean isClear) {
        if (isClear.booleanValue()) {
            this.clear();
        }
        this.update(dataList);
    }

    public void update(T item) {
        if (item != null) {
            this.mDatas.add(item);
        }
        this.notifyItemChanged(this.getItemCount() - 1);
        this.mItemViewDelegateManager.notifyDataSetChanged(this.mDatas);
    }

    public void update(List<T> itemList) {
        if (itemList == null || itemList.isEmpty()) {
            return;
        }
        if (itemList.size() == 1) {
            this.update(itemList.get(0));
            return;
        }
        this.mDatas.addAll(itemList);
        this.notifyDataSetChanged();
        this.mItemViewDelegateManager.notifyDataSetChanged(this.mDatas);
    }

    public void clear() {
        this.mDatas.clear();
        this.notifyDataSetChanged();
        this.mItemViewDelegateManager.notifyDataSetChanged(this.mDatas);
    }

    public void remove(int position) {
        if (this.mDatas != null && this.mDatas.size() > 0) {
            this.mDatas.remove(position);
            this.notifyItemRemoved(position);
            if (position != this.mDatas.size()) {
                this.notifyItemRangeChanged(position, this.getItemCount() - position);
            }
        }
    }

    public List<T> getDataList() {
        return this.mDatas;
    }

    public void setDataList(Collection<T> list) {
        this.mDatas.clear();
        this.mDatas.addAll(list);
        this.notifyDataSetChanged();
        this.mItemViewDelegateManager.notifyDataSetChanged(this.mDatas);
    }

    public static interface OnItemClickListener {
        public void onItemClick(View var1, RecyclerView.ViewHolder var2, int var3);

        public boolean onItemLongClick(View var1, RecyclerView.ViewHolder var2, int var3);
    }
}

