/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.ui.dialog;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.view.View;
import androidx.annotation.NonNull;
import net.aihelp.core.ui.dialog.AlertController;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;

public class AlertDialog
extends Dialog {
    public AlertController mAlert = new AlertController(this, this.getWindow());
    private static long sLastObjectCreatedTime = 0L;

    public AlertDialog(@NonNull Context context, int themeResId) {
        super(context, themeResId);
    }

    public void setText(int viewId, CharSequence text) {
        this.mAlert.setText(viewId, text);
    }

    public void setOnClickListener(int viewId, View.OnClickListener listener) {
        this.mAlert.setOnClickListener(viewId, listener);
    }

    public <V extends View> V getView(int viewId) {
        return this.mAlert.getView(viewId);
    }

    public static class Builder {
        public final AlertController.AlertParams P;
        private Context mContext;
        private OnSingleConfirmListener mSingleConfirmListener;
        private OnDoubleChoiceListener mDoubleConfirmListener;

        public Builder(Context context) {
            this(context, ResResolver.getStyleId("aihelp_dialog"));
            this.mContext = context;
        }

        public Builder(Context context, int themeResId) {
            this.P = new AlertController.AlertParams(context, themeResId);
        }

        public AlertController.AlertParams getAlertParams() {
            return this.P;
        }

        public Builder setContentView(int layoutResId) {
            this.P.mView = null;
            this.P.mViewLayoutResId = layoutResId;
            return this;
        }

        public Builder setContentView(View view) {
            this.P.mView = view;
            this.P.mViewLayoutResId = 0;
            return this;
        }

        public Builder setCancelViewId(int cancelViewId) {
            this.P.mCancelViewId = cancelViewId;
            return this;
        }

        public Builder setConfirmViewId(int confirmViewId) {
            this.P.mSingleConfirmViewId = confirmViewId;
            return this;
        }

        public Builder setDoubleConfirmViewId(int leftId, int rightId) {
            this.P.mLeftConfirmViewId = leftId;
            this.P.mRightConfirmViewId = rightId;
            return this;
        }

        public Builder setBottomTextViewId(int bottomTextViewId) {
            this.P.mBottomTextViewId = bottomTextViewId;
            return this;
        }

        public Builder setOnCancelListener(DialogInterface.OnCancelListener onCancelListener) {
            this.P.mOnCancelListener = onCancelListener;
            return this;
        }

        public Builder setCancelableOntheOutside(boolean cancelable) {
            this.P.mCancelable = cancelable;
            return this;
        }

        public Builder setText(int viewId, CharSequence text) {
            this.P.mTextArray.put(viewId, (Object)text);
            return this;
        }

        public Builder setTextBackground(int viewId, int drawableResId) {
            this.P.mBackgroundResArray.put(viewId, (Object)drawableResId);
            return this;
        }

        public Builder setOnClickListener(int view, View.OnClickListener listener) {
            this.P.mClickArray.put(view, (Object)listener);
            return this;
        }

        public Builder setOnDismissListener(DialogInterface.OnDismissListener onDismissListener) {
            this.P.mOnDismissListener = onDismissListener;
            return this;
        }

        public Builder setOnKeyListener(DialogInterface.OnKeyListener onKeyListener) {
            this.P.mOnKeyListener = onKeyListener;
            return this;
        }

        public Builder fullWidth() {
            this.P.mWidth = -1;
            return this;
        }

        public Builder fromBottom(boolean isAnimation) {
            if (isAnimation) {
                this.P.mAnimation = ResResolver.getStyleId("aihelp_dialog_from_bottom_anim");
            }
            this.P.mGravity = 80;
            return this;
        }

        public Builder fromRight(boolean isAnimation) {
            if (isAnimation) {
                this.P.mAnimation = ResResolver.getStyleId("aihelp_dialog_from_right_anim");
            }
            this.P.mGravity = 0x800005;
            return this;
        }

        public Builder setWidthAndHeight(int width, int height) {
            this.P.mWidth = this.dip2px(this.mContext, width);
            this.P.mHeight = this.dip2px(this.mContext, height);
            if (width == -1 || width == -2) {
                this.P.mWidth = width;
            }
            if (height == -1 || height == -2) {
                this.P.mHeight = height;
            }
            return this;
        }

        public Builder setWidthByDevice() {
            int screenWidth = Styles.getScreenWidth(this.mContext);
            this.P.mWidth = (int)((double)screenWidth * 0.725);
            return this;
        }

        public Builder setHeightByDevice() {
            int screenHeight = Styles.getScreenHeight(this.mContext);
            this.P.mHeight = (int)((double)screenHeight * 0.725);
            return this;
        }

        public Builder setGravity(int gravity) {
            this.P.mGravity = gravity;
            return this;
        }

        public void setBottomText(String text) {
            this.P.mTextArray.put(this.P.mBottomTextViewId, (Object)text);
        }

        public AlertDialog create() {
            AlertDialog dialog = new AlertDialog(this.P.mContext, this.P.mThemeResId);
            this.P.apply(dialog.mAlert);
            dialog.setCancelable(this.P.mCancelable);
            if (this.P.mCancelable) {
                dialog.setCanceledOnTouchOutside(true);
            }
            dialog.setOnCancelListener(this.P.mOnCancelListener);
            dialog.setOnDismissListener(this.P.mOnDismissListener);
            if (this.P.mOnKeyListener != null) {
                dialog.setOnKeyListener(this.P.mOnKeyListener);
            }
            this.setClickListeners(dialog);
            return dialog;
        }

        private void setClickListeners(final AlertDialog dialog) {
            if (this.P.mCancelViewId != 0) {
                dialog.getView(this.P.mCancelViewId).setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        dialog.dismiss();
                    }
                });
            }
            if (this.P.mSingleConfirmViewId != 0 && this.mSingleConfirmListener != null) {
                dialog.getView(this.P.mSingleConfirmViewId).setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        mSingleConfirmListener.onConfirmClicked(dialog);
                    }
                });
            }
            if (this.P.mLeftConfirmViewId != 0 && this.mDoubleConfirmListener != null) {
                dialog.getView(this.P.mLeftConfirmViewId).setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        mDoubleConfirmListener.onCancelClicked(dialog);
                    }
                });
            }
            if (this.P.mRightConfirmViewId != 0 && this.mDoubleConfirmListener != null) {
                dialog.getView(this.P.mRightConfirmViewId).setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        mDoubleConfirmListener.onConfirmClicked(dialog);
                    }
                });
            }
        }

        public AlertDialog show() {
            AlertDialog dialog = this.create();
            if (System.currentTimeMillis() - sLastObjectCreatedTime > 1000L) {
                dialog.show();
                sLastObjectCreatedTime = System.currentTimeMillis();
            }
            return dialog;
        }

        public Builder setOnSingleConfirmListener(OnSingleConfirmListener listener) {
            this.mSingleConfirmListener = listener;
            return this;
        }

        public Builder setOnDoubleChoiceListener(OnDoubleChoiceListener listener) {
            this.mDoubleConfirmListener = listener;
            return this;
        }

        public int dip2px(Context context, double dpValue) {
            float density = context.getResources().getDisplayMetrics().density;
            return (int)(dpValue * (double)density + 0.5);
        }

        public static int px2dip(Context context, float pxValue) {
            float scale = context.getResources().getDisplayMetrics().density;
            return (int)(pxValue / scale + 0.5f);
        }

        public static interface OnDoubleChoiceListener {
            public void onCancelClicked(AlertDialog var1);

            public void onConfirmClicked(AlertDialog var1);
        }

        public static interface OnSingleConfirmListener {
            public void onConfirmClicked(AlertDialog var1);
        }
    }
}

