/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.ui.image;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.widget.ImageView;
import net.aihelp.core.ui.image.Action;
import net.aihelp.core.ui.image.Callback;
import net.aihelp.core.ui.image.Picasso;
import net.aihelp.core.ui.image.PicassoDrawable;
import net.aihelp.core.ui.image.Request;

class ImageViewAction
extends Action<ImageView> {
    Callback callback;

    ImageViewAction(Picasso picasso, ImageView imageView, Request data, int memoryPolicy, int networkPolicy, int errorResId, Drawable errorDrawable, String key, Object tag, Callback callback, boolean noFade) {
        super(picasso, imageView, data, memoryPolicy, networkPolicy, errorResId, errorDrawable, key, tag, noFade);
        this.callback = callback;
    }

    @Override
    public void complete(Bitmap result, Picasso.LoadedFrom from) {
        if (result == null) {
            throw new AssertionError((Object)String.format("Attempted to complete action with no result!\n%s", this));
        }
        Context context = this.picasso.context;
        boolean indicatorsEnabled = this.picasso.indicatorsEnabled;
        PicassoDrawable.setBitmap((ImageView)this.target, context, result, from, this.noFade, indicatorsEnabled);
        if (this.callback != null) {
            this.callback.onSuccess();
        }
    }

    @Override
    public void error(Exception e) {
        Drawable placeholder = ((ImageView)this.target).getDrawable();
        if (placeholder instanceof Animatable) {
            ((Animatable)placeholder).stop();
        }
        if (this.errorResId != 0) {
            ((ImageView)this.target).setImageResource(this.errorResId);
        } else if (this.errorDrawable != null) {
            ((ImageView)this.target).setImageDrawable(this.errorDrawable);
        }
        if (this.callback != null) {
            this.callback.onError(e);
        }
    }

    @Override
    void cancel() {
        super.cancel();
        if (this.callback != null) {
            this.callback = null;
        }
    }
}

