/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.ui.image;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import java.io.IOException;
import net.aihelp.core.ui.image.Picasso;
import net.aihelp.core.ui.image.Request;
import net.aihelp.core.ui.image.RequestHandler;
import net.aihelp.core.ui.image.Utils;

class ResourceRequestHandler
extends RequestHandler {
    private final Context context;

    ResourceRequestHandler(Context context) {
        this.context = context;
    }

    @Override
    public boolean canHandleRequest(Request data) {
        if (data.resourceId != 0) {
            return true;
        }
        return "android.resource".equals(data.uri.getScheme());
    }

    @Override
    public RequestHandler.Result load(Request request, int networkPolicy) throws IOException {
        Resources res = Utils.getResources(this.context, request);
        int id2 = Utils.getResourceId(res, request);
        return new RequestHandler.Result(ResourceRequestHandler.decodeResource(res, id2, request), Picasso.LoadedFrom.DISK);
    }

    private static Bitmap decodeResource(Resources resources, int id2, Request data) {
        BitmapFactory.Options options = ResourceRequestHandler.createBitmapOptions(data);
        if (ResourceRequestHandler.requiresInSampleSize(options)) {
            BitmapFactory.decodeResource((Resources)resources, (int)id2, (BitmapFactory.Options)options);
            ResourceRequestHandler.calculateInSampleSize(data.targetWidth, data.targetHeight, options, data);
        }
        return BitmapFactory.decodeResource((Resources)resources, (int)id2, (BitmapFactory.Options)options);
    }
}

