/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.ui.image;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import androidx.appcompat.content.res.AppCompatResources;
import net.aihelp.core.ui.image.Action;
import net.aihelp.core.ui.image.Picasso;
import net.aihelp.core.ui.image.Request;
import net.aihelp.core.ui.image.Target;

final class TargetAction
extends Action<Target> {
    TargetAction(Picasso picasso, Target target, Request data, int memoryPolicy, int networkPolicy, Drawable errorDrawable, String key, Object tag, int errorResId) {
        super(picasso, target, data, memoryPolicy, networkPolicy, errorResId, errorDrawable, key, tag, false);
    }

    @Override
    void complete(Bitmap result, Picasso.LoadedFrom from) {
        if (result == null) {
            throw new AssertionError((Object)String.format("Attempted to complete action with no result!\n%s", this));
        }
        Target target = (Target)this.getTarget();
        if (target != null) {
            target.onBitmapLoaded(result, from);
            if (result.isRecycled()) {
                throw new IllegalStateException("Target callback must not recycle bitmap!");
            }
        }
    }

    @Override
    void error(Exception e) {
        Target target = (Target)this.getTarget();
        if (target != null) {
            if (this.errorResId != 0) {
                target.onBitmapFailed(e, AppCompatResources.getDrawable((Context)this.picasso.context, (int)this.errorResId));
            } else {
                target.onBitmapFailed(e, this.errorDrawable);
            }
        }
    }
}

