/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.ui.loading.helper;

import android.app.Activity;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import java.lang.ref.WeakReference;
import net.aihelp.utils.TLog;

public class VaryViewHelper {
    private WeakReference<Activity> mActivityRef;
    private View mOriginView;
    private ViewGroup mParentView;
    private int mTargetViewIndex = -1;
    private ViewGroup.LayoutParams mOriginViewParams;

    VaryViewHelper(View view) {
        if (view.getContext() instanceof Activity) {
            this.mActivityRef = new WeakReference<Activity>((Activity)view.getContext());
        }
        this.mOriginView = view;
        this.prepareOriginViewCache();
    }

    private void prepareOriginViewCache() {
        this.mOriginViewParams = this.mOriginView.getLayoutParams();
        this.mParentView = (ViewGroup)this.mOriginView.getParent();
        if (this.mParentView != null) {
            for (int index = 0; index < this.mParentView.getChildCount(); ++index) {
                if (this.mOriginView != this.mParentView.getChildAt(index)) continue;
                this.mTargetViewIndex = index;
                break;
            }
        }
    }

    void showLayout(View replaceView) {
        if (this.mActivityRef.get() != null && !((Activity)this.mActivityRef.get()).isFinishing()) {
            if (this.mParentView == null || this.mParentView.getChildAt(this.mTargetViewIndex) == replaceView) {
                TLog.e("mParentView == null -- > " + (this.mParentView == null));
                TLog.e("mParentView.getChildAt(mTargetViewIndex) == replaceView -- > " + (this.mParentView.getChildAt(this.mTargetViewIndex) == replaceView));
                return;
            }
            this.mParentView.removeViewAt(this.mTargetViewIndex);
            this.mParentView.addView(replaceView, this.mTargetViewIndex, this.mOriginViewParams);
        }
    }

    void restoreView() {
        if (this.mActivityRef.get() != null && !((Activity)this.mActivityRef.get()).isFinishing()) {
            this.showLayout(this.mOriginView);
        }
    }

    public View inflate(int layoutId) {
        return LayoutInflater.from((Context)this.mOriginView.getContext()).inflate(layoutId, null);
    }

    public Context getContext() {
        return this.mOriginView.getContext();
    }

    public View getTargetView() {
        return this.mOriginView;
    }
}

