/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.util.concurrent;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import net.aihelp.core.util.concurrent.ApiExecutor;
import net.aihelp.core.util.concurrent.NotifyingRunnable;

public class HandlerThreadExecutor
implements ApiExecutor {
    private final Object syncLock = new Object();
    private Handler uiHandler;
    private Handler handler;

    public HandlerThreadExecutor(String name) {
        HandlerThread handlerThread = new HandlerThread(name);
        handlerThread.start();
        this.handler = new Handler(handlerThread.getLooper());
        this.uiHandler = new Handler(Looper.getMainLooper());
    }

    @Override
    public void runAsync(Runnable r) {
        this.handler.post(r);
    }

    @Override
    public void runAsyncDelayed(Runnable r, long delayMillis) {
        this.handler.postDelayed(r, delayMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runSync(Runnable r) {
        NotifyingRunnable runnable = new NotifyingRunnable(r);
        Object object = this.syncLock;
        synchronized (object) {
            this.handler.post((Runnable)runnable);
            runnable.waitForCompletion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runSyncDelayed(Runnable r, long delayMillis) {
        NotifyingRunnable runnable = new NotifyingRunnable(r);
        Object object = this.syncLock;
        synchronized (object) {
            this.handler.postDelayed((Runnable)runnable, delayMillis);
            runnable.waitForCompletion();
        }
    }

    @Override
    public void runOnUiThread(final Runnable r) {
        this.runAsync(new Runnable(){

            @Override
            public void run() {
                HandlerThreadExecutor.this.uiHandler.post(r);
            }
        });
    }

    @Override
    public void awaitForSyncExecution() {
        this.runSync(new Runnable(){

            @Override
            public void run() {
            }
        });
    }
}

