/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.util.crash;

import android.content.Context;
import android.os.Looper;
import android.util.Log;
import androidx.annotation.NonNull;
import net.aihelp.core.util.crash.OnExceptionCaughtListener;
import net.aihelp.core.util.logger.AIHelpLogger;

public enum AIHelpCrashHandler implements OnExceptionCaughtListener
{
    INSTANCE;

    private static final CharSequence AIHELP_PACKAGE_NAME;
    private static boolean sInstalled;

    public void init(final Context context) {
        if (sInstalled) {
            return;
        }
        final Thread.UncaughtExceptionHandler defaultUncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(@NonNull Thread thread, @NonNull Throwable throwable) {
                if (AIHelpCrashHandler.isCrashedByAIHelp(throwable)) {
                    AIHelpCrashHandler.this.onExceptionCaught(context, throwable);
                } else if (defaultUncaughtExceptionHandler != null) {
                    defaultUncaughtExceptionHandler.uncaughtException(thread, throwable);
                }
            }
        });
        sInstalled = true;
    }

    @Override
    public void onExceptionCaught(Context context, Throwable throwable) {
        AIHelpLogger.fatal(throwable.getMessage(), throwable);
        if (Thread.currentThread() == Looper.getMainLooper().getThread()) {
            while (true) {
                try {
                    while (true) {
                        Looper.loop();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    if (this.throwChoreographerException(exception)) break;
                    AIHelpLogger.fatal(exception.getMessage(), exception);
                    continue;
                }
                break;
            }
        }
    }

    private static boolean isCrashedByAIHelp(Throwable throwable) {
        if (throwable == null) {
            return false;
        }
        String stackTrace = Log.getStackTraceString((Throwable)throwable);
        return stackTrace.contains(AIHELP_PACKAGE_NAME);
    }

    private boolean throwChoreographerException(Throwable e) {
        if (e == null) {
            return false;
        }
        StackTraceElement[] elements = e.getStackTrace();
        for (int i = elements.length - 1; i > -1; --i) {
            if (elements.length - i > 20) {
                return false;
            }
            StackTraceElement element = elements[i];
            if (!"android.view.Choreographer".equals(element.getClassName()) || !"Choreographer.java".equals(element.getFileName()) || !"doFrame".equals(element.getMethodName())) continue;
            return true;
        }
        return false;
    }

    static {
        AIHELP_PACKAGE_NAME = "net.aihelp";
        sInstalled = false;
    }
}

