/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.util.elva;

import java.beans.PropertyChangeEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.aihelp.core.util.elva.ContextPropertyChangeListener;
import net.aihelp.core.util.elva.ContextRandomSeedChangeListener;
import net.aihelp.core.util.elva.ContextTopicChangeListener;
import net.aihelp.core.util.elva.text.Request;
import net.aihelp.core.util.elva.text.Response;
import net.aihelp.core.util.elva.text.Sentence;
import net.aihelp.core.util.elva.text.Transformations;

public class Context {
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private final Map<String, ContextPropertyChangeListener> listeners = new HashMap<String, ContextPropertyChangeListener>();
    private final List<Request> requests = new LinkedList<Request>();
    private final List<Response> responses = new LinkedList<Response>();
    private final Random random = new Random();
    private long seed = 0L;
    private OutputStream output;
    private Sentence that;
    private Sentence topic;
    private Transformations transformations;

    public Context() {
        this.addContextPropertyChangeListener(new ContextRandomSeedChangeListener());
        this.addContextPropertyChangeListener(new ContextTopicChangeListener());
    }

    public Context(Transformations transformations) {
        this();
        this.transformations = transformations;
    }

    public void addContextPropertyChangeListener(ContextPropertyChangeListener listener) {
        this.listeners.put(listener.name(), listener);
    }

    public void removeContextPropertyChangeListener(ContextPropertyChangeListener listener) {
        ContextPropertyChangeListener listening = this.listeners.get(listener.name());
        if (listening == listener) {
            this.listeners.remove(listener.name());
        }
    }

    public void appendRequest(Request request) {
        this.requests.add(0, request);
    }

    public void appendResponse(Response response) {
        this.transformations.normalization(response);
        this.responses.add(0, response);
        this.that = response.lastSentence(0);
        this.transformations.normalization(this.that);
    }

    public void print(String output) throws IOException {
        this.outputStream().write(output.getBytes());
        this.outputStream().write(10);
    }

    public Object property(String name) {
        return this.properties.get(name);
    }

    public void property(String name, Object value) {
        ContextPropertyChangeListener listener = this.listeners.get(name);
        if (listener != null) {
            Object oldValue = this.properties.get(name);
            PropertyChangeEvent event = new PropertyChangeEvent(this, name, oldValue, value);
            listener.propertyChange(event);
        }
        this.properties.put(name, value);
    }

    public OutputStream outputStream() throws IOException {
        if (this.output == null) {
            String path = (String)this.property("bot.output");
            File file = new File(path);
            if (file.isDirectory()) {
                path = file.getPath() + "/gossip-" + this.id() + ".txt";
            }
            this.outputStream(new FileOutputStream(path));
        }
        return this.output;
    }

    public void outputStream(OutputStream output) {
        this.output = output;
    }

    public String id() {
        String id2 = (String)this.property("bot.id");
        if ("".equals(id2)) {
            return Integer.toString(this.hashCode());
        }
        return id2;
    }

    public Random random() {
        return this.random;
    }

    public void random(long seed) {
        this.random.setSeed(seed);
    }

    public Sentence getThat() {
        if (this.that == null) {
            this.that = Sentence.ASTERISK;
        }
        return this.that;
    }

    public Sentence getTopic() {
        if (this.topic == null) {
            this.topic = Sentence.ASTERISK;
        }
        return this.topic;
    }

    public void setTopic(Sentence topic) {
        if (topic == null) {
            this.topic = Sentence.ASTERISK;
        }
        this.topic = topic;
    }

    public Request getRequests(int index) {
        return this.requests.get(index);
    }

    public Response getResponses(int index) {
        return this.responses.get(index);
    }

    public Transformations getTransformations() {
        return this.transformations;
    }

    public void setTransformations(Transformations transformations) {
        this.transformations = transformations;
    }
}

