/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.util.elva;

import net.aihelp.core.util.elva.Context;
import net.aihelp.core.util.elva.Graphmaster;
import net.aihelp.core.util.elva.Match;
import net.aihelp.core.util.elva.aiml.Category;
import net.aihelp.core.util.elva.text.Request;
import net.aihelp.core.util.elva.text.Response;
import net.aihelp.core.util.elva.text.Sentence;
import net.aihelp.core.util.elva.text.Transformations;

public class ElvaBot {
    private Context context;
    private Graphmaster graphmaster;

    public ElvaBot() {
    }

    public ElvaBot(Graphmaster graphmaster) {
        this.setContext(new Context());
        this.setGraphmaster(graphmaster);
    }

    public ElvaBot(Context context, Graphmaster graphmaster) {
        this.setContext(context);
        this.setGraphmaster(graphmaster);
    }

    private void respond(Sentence sentence, Sentence that, Sentence topic, Response response) {
        Match match;
        Category category;
        if (sentence.length() > 0 && (category = this.graphmaster.match(match = new Match(this, sentence, that, topic))) != null) {
            response.append(category.process(match));
            if (category.getUrl() != null) {
                response.url = category.getUrl();
            }
            if (category.getUrl2() != null) {
                response.url2 = category.getUrl2();
            }
            if (category.getAlicekm() != null) {
                response.alicekm = category.getAlicekm();
            }
            response.pattern = category.getPattern();
            response.Actions = category.getActions();
            response.tags = category.getTags();
        }
    }

    public Response respond(Request request) {
        String original = request.getOriginal();
        if (original == null || "".equals(original.trim())) {
            return new Response("");
        }
        Sentence that = this.context.getThat();
        Sentence topic = this.context.getTopic();
        this.transformations().normalization(request);
        this.context.appendRequest(request);
        Response response = new Response();
        for (Sentence sentence : request.getSentences()) {
            this.respond(sentence, that, topic, response);
        }
        this.context.appendResponse(response);
        return response;
    }

    public String respond(String input) {
        Response response = this.respond(new Request(input));
        return response.trimOriginal();
    }

    public Response response(String input) {
        return this.respond(new Request(input));
    }

    public String respondXml(String input) {
        int i;
        Response response = this.respond(new Request(input));
        String responseori = response.trimOriginal();
        StringBuilder output = new StringBuilder();
        output.append("<msgs><msg>").append(responseori.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&apos;")).append("</msg>");
        if (response.url != null) {
            output.append(response.url.process(null));
        }
        if (response.url2 != null) {
            output.append(response.url2.process(null));
        }
        if (response.alicekm != null) {
            output.append(response.alicekm.process(null));
        }
        if (response.Actions != null && response.Actions.size() > 0) {
            output.append("<actions>");
            for (i = 0; i < response.Actions.size(); ++i) {
                output.append("<action>");
                output.append(response.Actions.get(i).process(null));
                output.append("</action>");
            }
            if (response.Actions.size() == 1) {
                output.append("<action\n\t\t\tname=\"\"\n\t\t\treply=\"\"></action>");
            }
            output.append("</actions>");
        }
        if (response.tags != null && response.tags.size() > 0) {
            output.append("<tags>");
            for (i = 0; i < response.tags.size(); ++i) {
                output.append("<tag>");
                output.append(response.tags.get(i).process(null));
                output.append("</tag>");
            }
            if (response.tags.size() == 1) {
                output.append("<tag\n\t\t\tname=\"\"\n\t\t\tid=\"\"></tag>");
            }
            output.append("</tags>");
        }
        output.append("</msgs>");
        return output.toString();
    }

    public Transformations transformations() {
        return this.context.getTransformations();
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public Graphmaster getGraphmaster() {
        return this.graphmaster;
    }

    public void setGraphmaster(Graphmaster graphmaster) {
        this.graphmaster = graphmaster;
    }
}

