/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.util.elva;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.aihelp.core.util.elva.Match;
import net.aihelp.core.util.elva.aiml.Category;

public class Graphmaster {
    private final Map<String, Graphmaster> children = new HashMap<String, Graphmaster>();
    private int size = 0;
    private Graphmaster parent;
    private Category category;
    private String name;

    private Graphmaster(String name) {
        this.name = name;
    }

    public Graphmaster() {
    }

    public Graphmaster(List<Category> categories) {
        this.append(categories);
    }

    private void append(Category category, String[] elements, int index) {
        int nextIndex;
        Graphmaster child = this.children.get(elements[index]);
        if (child == null) {
            child = new Graphmaster(elements[index]);
            this.appendChild(child);
        }
        if (elements.length <= (nextIndex = index + 1)) {
            child.category = category;
        } else {
            child.append(category, elements, nextIndex);
        }
    }

    private void appendChild(Graphmaster child) {
        this.children.put(child.name, child);
        child.parent = this;
    }

    private Graphmaster[] children(String name) {
        return new Graphmaster[]{this.children.get("_"), this.children.get(name), this.children.get("*")};
    }

    private boolean isWildcard() {
        return "_".equals(this.name) || "*".equals(this.name);
    }

    private Category match(Match match, int index) {
        if (this.isWildcard()) {
            return this.matchWildcard(match, index);
        }
        if (!this.name.equals(match.getMatchPath(index))) {
            return null;
        }
        int nextIndex = index + 1;
        if (match.getMatchPathLength() <= nextIndex) {
            return this.category;
        }
        return this.matchChildren(match, nextIndex);
    }

    private Category matchChildren(Match match, int nextIndex) {
        Graphmaster[] nodes = this.children(match.getMatchPath(nextIndex));
        int n = nodes.length;
        for (int i = 0; i < n; ++i) {
            Category category;
            Category category2 = category = nodes[i] != null ? nodes[i].match(match, nextIndex) : null;
            if (category == null) continue;
            return category;
        }
        return null;
    }

    private Category matchWildcard(Match match, int index) {
        int n = match.getMatchPathLength();
        for (int i = index; i < n; ++i) {
            Category category = this.matchChildren(match, i);
            if (category == null) continue;
            match.appendWildcard(index, i);
            return category;
        }
        if (this.category != null) {
            match.appendWildcard(index, n);
        }
        return this.category;
    }

    public void append(List<Category> categories) {
        for (Category category : categories) {
            this.append(category);
        }
    }

    public void append(Category category) {
        String[] matchPath = category.getMatchPath();
        this.append(category, matchPath, 0);
        ++this.size;
    }

    public Category match(Match match) {
        return this.matchChildren(match, 0);
    }

    public int size() {
        return this.size;
    }
}

