/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.util.elva.aiml;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.aihelp.core.util.elva.aiml.AIMLElement;
import net.aihelp.core.util.elva.aiml.AIMLStack;
import net.aihelp.core.util.elva.aiml.Aiml;
import net.aihelp.core.util.elva.aiml.Category;
import net.aihelp.core.util.elva.aiml.Text;
import net.aihelp.core.util.elva.util.ParseUtil;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class AIMLHandler
extends DefaultHandler {
    private final Set<String> ignored = new HashSet<String>();
    final StringBuilder text = new StringBuilder();
    private boolean ignoreWhitespace = true;
    final AIMLStack stack = new AIMLStack();

    public AIMLHandler(String ... ignore) {
        this.ignored.addAll(Arrays.asList(ignore));
    }

    private String buildClassName(String tag) {
        return "net.aihelp.core.util.elva.aiml." + tag.substring(0, 1).toUpperCase() + tag.substring(1).toLowerCase();
    }

    private void pushTextNode(Boolean blankSplit) {
        String pushed = this.text.toString();
        this.text.delete(0, this.text.length());
        if (blankSplit.booleanValue()) {
            pushed = ParseUtil.blankSplit(pushed);
        }
        if (this.ignoreWhitespace) {
            pushed = pushed.replaceAll("[ ]{2,}", " ");
        }
        if (!"".equals(pushed.trim())) {
            this.stack.push(new Text(pushed));
        }
    }

    private void updateIgnoreWhitespace(Attributes attributes) {
        try {
            this.ignoreWhitespace = !"preserve".equals(attributes.getValue("xml:space"));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public List<Category> unload() {
        Object poped;
        LinkedList<Category> result = new LinkedList<Category>();
        while ((poped = this.stack.pop()) != null) {
            if (!(poped instanceof Aiml)) continue;
            result.addAll(((Aiml)poped).children());
        }
        return result;
    }

    @Override
    public void characters(char[] chars, int start, int length) {
        this.text.append(chars, start, length);
    }

    @Override
    public void startElement(String namespace, String name, String qname, Attributes attributes) {
        if (this.ignored.contains(qname)) {
            return;
        }
        this.updateIgnoreWhitespace(attributes);
        Boolean blankSplit = ParseUtil.needBlankSplit(qname);
        this.pushTextNode(blankSplit);
        String className = this.buildClassName(qname);
        try {
            Class<?> tagClass = Class.forName(className);
            Constructor<?> constructor = tagClass.getConstructor(Attributes.class);
            Object tag = constructor.newInstance(attributes);
            this.stack.push(tag);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void endElement(String namespace, String name, String qname) {
        if (this.ignored.contains(qname)) {
            return;
        }
        Boolean blankSplit = ParseUtil.needBlankSplit(qname);
        this.pushTextNode(blankSplit);
        this.ignoreWhitespace = true;
        String className = this.buildClassName(qname);
        try {
            Class<?> aClass = Class.forName(className);
            LinkedList<AIMLElement> children = new LinkedList<AIMLElement>();
            while (true) {
                Object tag;
                if ((tag = this.stack.pop()) == null) {
                    throw new SAXException("No matching start tag found for " + qname);
                }
                if (!className.equals(tag.getClass().getName())) {
                    children.add(0, (AIMLElement)tag);
                    continue;
                }
                try {
                    if (children.size() > 0) {
                        ((AIMLElement)tag).appendChildren(children);
                    }
                    this.stack.push(tag);
                    return;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }
}

