/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.util.elva.aiml;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import net.aihelp.core.util.elva.aiml.AIMLElement;
import net.aihelp.core.util.elva.aiml.Category;
import net.aihelp.core.util.elva.aiml.Topic;
import org.xml.sax.Attributes;

public class Aiml
implements AIMLElement {
    private final Topic defaultTopic = new Topic("*", new Category[0]);
    private final List<Topic> topics = new LinkedList<Topic>(Arrays.asList(this.defaultTopic));
    private final List<Category> categories = new LinkedList<Category>();
    private String version;

    public Aiml(Attributes attributes) {
        this.version = attributes.getValue(0);
    }

    public Aiml(Category ... categories) {
        this.categories.addAll(Arrays.asList(categories));
    }

    @Override
    public void appendChild(AIMLElement child) {
        if (child instanceof Category) {
            Category category = (Category)child;
            category.setTopic(this.defaultTopic);
            this.defaultTopic.appendChild(category);
            this.categories.add(category);
        } else {
            try {
                Topic topic = (Topic)child;
                this.topics.add(topic);
                this.categories.addAll(topic.categories());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void appendChildren(List<AIMLElement> children) {
        for (AIMLElement child : children) {
            this.appendChild(child);
        }
    }

    public List<Category> children() {
        return this.categories;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Aiml)) {
            return false;
        }
        return this.categories.equals(((Aiml)obj).categories);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (Category i : this.categories) {
            result.append(i);
            result.append('\n');
        }
        return result.toString();
    }

    public String getVersion() {
        return this.version;
    }
}

