/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.util.elva.aiml;

import java.util.ArrayList;
import java.util.List;
import net.aihelp.core.util.elva.Match;
import net.aihelp.core.util.elva.aiml.AIMLElement;
import net.aihelp.core.util.elva.aiml.Action;
import net.aihelp.core.util.elva.aiml.Alicekm;
import net.aihelp.core.util.elva.aiml.Pattern;
import net.aihelp.core.util.elva.aiml.Tag;
import net.aihelp.core.util.elva.aiml.Template;
import net.aihelp.core.util.elva.aiml.That;
import net.aihelp.core.util.elva.aiml.Topic;
import net.aihelp.core.util.elva.aiml.Url;
import net.aihelp.core.util.elva.aiml.Url2;
import org.xml.sax.Attributes;

public class Category
implements AIMLElement {
    private Pattern pattern;
    private Template template;
    private That that;
    private Topic topic;
    private List<Action> actions = new ArrayList<Action>();
    private List<Tag> tags = new ArrayList<Tag>();
    private Url url = null;
    private Url2 url2 = null;
    private Alicekm alicekm = null;

    public Category() {
    }

    public Category(Attributes attributes) {
    }

    public Category(String pattern, Object ... children) {
        this(new Pattern(pattern), new That("*"), new Topic("*", new Category[0]), new Template(children));
    }

    public Category(Pattern pattern, Template template) {
        this(pattern, new That("*"), new Topic("*", new Category[0]), template);
    }

    public Category(Pattern pattern, That that, Template template) {
        this(pattern, that, new Topic("*", new Category[0]), template);
    }

    public Category(Pattern pattern, That that, Topic topic, Template template) {
        this(pattern, that, topic, template, new Url(), new Url2(), new Alicekm(), new ArrayList<Tag>(), new Action[0]);
    }

    public Category(Pattern pattern, That that, Topic topic, Template template, Url url, Url2 url2, Alicekm alicekm, List<Tag> tags, Action ... actions) {
        this.pattern = pattern;
        this.template = template;
        this.that = that;
        this.topic = topic;
        this.url = url;
        this.url2 = url2;
        this.actions = new ArrayList<Action>();
        this.tags = new ArrayList<Tag>();
        this.alicekm = alicekm;
        for (Action child : actions) {
            this.actions.add(child);
        }
        for (Tag tag : tags) {
            this.tags.add(tag);
        }
    }

    @Override
    public void appendChild(AIMLElement child) {
        if (child instanceof Pattern) {
            this.pattern = (Pattern)child;
        } else if (child instanceof That) {
            this.that = (That)child;
        } else if (child instanceof Url) {
            this.url = (Url)child;
        } else if (child instanceof Url2) {
            this.url2 = (Url2)child;
        } else if (child instanceof Action) {
            this.actions.add((Action)child);
        } else if (child instanceof Tag) {
            this.tags.add((Tag)child);
        } else if (child instanceof Alicekm) {
            this.alicekm = (Alicekm)child;
        } else if (child instanceof Template) {
            this.template = (Template)child;
        }
    }

    @Override
    public void appendChildren(List<AIMLElement> children) {
        for (AIMLElement child : children) {
            this.appendChild(child);
        }
        if (this.that == null) {
            this.that = new That("*");
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Category)) {
            return false;
        }
        Category compared = (Category)obj;
        return this.pattern.equals(compared.pattern) && this.template.equals(compared.template) && this.that.equals(compared.that);
    }

    public String toString() {
        return "[" + this.pattern.toString() + "][" + this.that.toString() + "][" + this.template.toString() + "]";
    }

    public String process(Match match) {
        if (this.url != null) {
            this.url.process(match);
        }
        if (this.url2 != null) {
            this.url2.process(match);
        }
        return this.template.process(match);
    }

    public String[] getMatchPath() {
        String[] pattPath = this.pattern.getElements();
        String[] thatPath = this.that.elements();
        String[] topicPath = this.topic.elements();
        int m = pattPath.length;
        int n = thatPath.length;
        int o = topicPath.length;
        String[] matchPath = new String[m + 1 + n + 1 + o];
        matchPath[m] = "<THAT>";
        matchPath[m + 1 + n] = "<TOPIC>";
        System.arraycopy(pattPath, 0, matchPath, 0, m);
        System.arraycopy(thatPath, 0, matchPath, m + 1, n);
        System.arraycopy(topicPath, 0, matchPath, m + 1 + n + 1, o);
        return matchPath;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    public Template getTemplate() {
        return this.template;
    }

    public void setTemplate(Template template) {
        this.template = template;
    }

    public That getThat() {
        return this.that;
    }

    public void setThat(That that) {
        this.that = that;
    }

    public Topic getTopic() {
        return this.topic;
    }

    public Url getUrl() {
        return this.url;
    }

    public Url2 getUrl2() {
        return this.url2;
    }

    public Alicekm getAlicekm() {
        return this.alicekm;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public List<Action> getActions() {
        return this.actions;
    }

    public void setTopic(Topic topic) {
        this.topic = topic;
    }
}

