/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.util.elva.aiml;

import net.aihelp.core.util.elva.Match;
import net.aihelp.core.util.elva.aiml.TemplateElement;
import net.aihelp.core.util.elva.text.Request;
import org.xml.sax.Attributes;

public class Input
extends TemplateElement {
    private int requestIndex = 1;
    private int sentenceIndex = 1;

    public Input(Attributes attributes) {
        super(new Object[0]);
        String value = attributes.getValue(0);
        if (value == null) {
            return;
        }
        String[] indexes = value.split(",");
        this.requestIndex = Integer.parseInt(indexes[0].trim());
        if (indexes.length > 1) {
            this.sentenceIndex = Integer.parseInt(indexes[1].trim());
        }
    }

    public Input(int requestIndex, int sentenceIndex) {
        super(new Object[0]);
        this.requestIndex = requestIndex;
        this.sentenceIndex = sentenceIndex;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        Input compared = (Input)obj;
        return this.requestIndex == compared.requestIndex && this.sentenceIndex == compared.sentenceIndex;
    }

    public String toString() {
        return "<input index=\"" + this.requestIndex + ", " + this.sentenceIndex + "\"/>";
    }

    @Override
    public String process(Match match) {
        if (match == null) {
            return "";
        }
        Request request = match.getCallback().getContext().getRequests(this.requestIndex - 1);
        return request.lastSentence(this.sentenceIndex - 1).trimOriginal();
    }
}

