/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.util.elva.aiml;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import net.aihelp.core.util.elva.aiml.AIMLElement;
import net.aihelp.core.util.elva.aiml.Category;
import org.xml.sax.Attributes;

public class Topic
implements AIMLElement {
    private List<Category> categories = new LinkedList<Category>();
    private String name;

    public Topic(Attributes attributes) {
        this.name(attributes.getValue(0));
    }

    public Topic(String name, Category ... children) {
        this.name(name);
        this.categories.addAll(Arrays.asList(children));
    }

    @Override
    public void appendChild(AIMLElement child) {
        Category category = (Category)child;
        category.setTopic(this);
        this.categories.add(category);
    }

    @Override
    public void appendChildren(List<AIMLElement> children) {
        for (AIMLElement child : children) {
            this.appendChild(child);
        }
    }

    public List<Category> categories() {
        return this.categories;
    }

    public String[] elements() {
        return this.name.split(" ");
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Topic)) {
            return false;
        }
        Topic compared = (Topic)obj;
        return this.name.equals(compared.name) && this.categories.equals(compared.categories);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (Category i : this.categories) {
            result.append(i);
            result.append('\n');
        }
        return result.toString();
    }

    private void name(String name) {
        this.name = name.trim();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

