/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.util.elva.parser;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.aihelp.core.util.elva.parser.ReflectionBuilder;
import net.aihelp.core.util.elva.util.Escaper;
import org.xml.sax.Attributes;

public class SubstitutionBuilder
implements ReflectionBuilder {
    private Map<String, Map<String, String>> substitutions;
    private Map<String, String> section;

    public SubstitutionBuilder() {
        this.substitutions = new HashMap<String, Map<String, String>>();
    }

    public SubstitutionBuilder(Map<String, Map<String, String>> substitutions) {
        this.substitutions = substitutions;
    }

    @Override
    public void characters(char[] chars, int start, int length) {
    }

    public void startAccentuation(Attributes attributes) {
        this.section = this.substitutions.get("accentuation");
    }

    public void startCorrection(Attributes attributes) {
        this.section = this.substitutions.get("correction");
    }

    public void startPerson(Attributes attributes) {
        this.section = this.substitutions.get("person");
    }

    public void startPerson2(Attributes attributes) {
        this.section = this.substitutions.get("person2");
    }

    public void startGender(Attributes attributes) {
        this.section = this.substitutions.get("gender");
    }

    public void startProtection(Attributes attributes) {
        this.section = this.substitutions.get("protection");
    }

    public void startPunctuation(Attributes attributes) {
        this.section = this.substitutions.get("punctuation");
    }

    public void startSubstitute(Attributes attributes) {
        String find = Escaper.escapeRegex(attributes.getValue(0));
        String replace = attributes.getValue(1);
        this.section.put(find, replace);
    }

    @Override
    public void clear() {
        this.substitutions.clear();
        this.substitutions.put("correction", new LinkedHashMap());
        this.substitutions.put("protection", new LinkedHashMap());
        this.substitutions.put("accentuation", new LinkedHashMap());
        this.substitutions.put("punctuation", new LinkedHashMap());
        this.substitutions.put("person", new LinkedHashMap());
        this.substitutions.put("person2", new LinkedHashMap());
        this.substitutions.put("gender", new LinkedHashMap());
    }

    public Map<String, Map<String, String>> parsed() {
        return new HashMap<String, Map<String, String>>(this.substitutions);
    }
}

