/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.util.elva.parser;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.aihelp.core.util.elva.config.ConfigException;
import net.aihelp.core.util.elva.config.TokenizerConfigStream;
import net.aihelp.core.util.elva.parser.ReflectionHandler;
import net.aihelp.core.util.elva.parser.SplitterHandler;
import net.aihelp.core.util.elva.parser.SubstitutionBuilder;
import net.aihelp.core.util.elva.text.Tokenizer;
import net.aihelp.core.util.elva.text.Transformations;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TransformationsParser {
    private final SubstitutionBuilder substBuilder = new SubstitutionBuilder();
    private final ReflectionHandler substHandler = new ReflectionHandler(this.substBuilder);
    private final SplitterHandler splitHandler = new SplitterHandler();
    private SAXParser parser = SAXParserFactory.newInstance().newSAXParser();

    private List<String> parseSplitters(InputStream splitters) throws IOException, SAXException {
        this.splitHandler.clear();
        this.parser.parse(splitters, (DefaultHandler)this.splitHandler);
        return this.splitHandler.parsed();
    }

    private Map<String, Map<String, String>> parseSubstitutions(InputStream substitutions) throws IOException, SAXException {
        this.substBuilder.clear();
        this.parser.parse(substitutions, (DefaultHandler)this.substHandler);
        return this.substBuilder.parsed();
    }

    private byte[] toByteArray(InputStream input) throws IOException {
        LinkedList<Byte> list = new LinkedList<Byte>();
        int i = 0;
        while ((i = input.read()) > -1) {
            list.add((byte)i);
        }
        i = 0;
        byte[] bytes = new byte[list.size()];
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            byte b = (Byte)iterator.next();
            bytes[i++] = b;
        }
        return bytes;
    }

    public Transformations parse(InputStream splitters, InputStream substitutions) throws ConfigException, IOException, SAXException {
        byte[] bytes = this.toByteArray(splitters);
        TokenizerConfigStream config = new TokenizerConfigStream(new ByteArrayInputStream(bytes));
        Tokenizer tokenizer = new Tokenizer(config);
        List<String> splitChars = this.parseSplitters(new ByteArrayInputStream(bytes));
        Map<String, Map<String, String>> maps = this.parseSubstitutions(substitutions);
        return new Transformations(splitChars, maps, tokenizer);
    }
}

