/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.util.elva.text;

import java.util.Arrays;

public class Sentence {
    private String original;
    private Integer[] mappings;
    private String normalized;
    private String[] splitted;
    public static final Sentence ASTERISK = new Sentence(" * ", new Integer[]{0, 2}, " * ");

    public Sentence(String original, Integer[] mappings, String normalized) {
        this.setOriginal(original);
        this.setMappings(mappings);
        this.setNormalized(normalized);
    }

    public Sentence(String original) {
        this(original, null, null);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Sentence)) {
            return false;
        }
        Sentence compared = (Sentence)obj;
        return this.original.equals(compared.original) && Arrays.equals((Object[])this.mappings, (Object[])compared.mappings) && this.normalized.equals(compared.normalized);
    }

    public int length() {
        return this.splitted.length;
    }

    public String[] normalized() {
        return this.splitted;
    }

    public String normalized(int index) {
        return this.splitted[index];
    }

    public String original(int beginIndex, int endIndex) {
        if (beginIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(beginIndex);
        }
        while (beginIndex >= 0 && this.mappings[beginIndex] == null) {
            --beginIndex;
        }
        int n = this.mappings.length;
        while (endIndex < n && this.mappings[endIndex] == null) {
            ++endIndex;
        }
        if (endIndex >= n) {
            endIndex = n - 1;
        }
        if (beginIndex >= 0 && endIndex >= 0 && this.mappings[beginIndex] != null && this.mappings[endIndex] != null) {
            String value = this.original.substring(this.mappings[beginIndex], this.mappings[endIndex] + 1);
            value = value.replaceAll("^[^A-Za-z0-9\\u4E00-\\u9FA5\\u3040-\\u31FE\\u0400-\\u04FF\\u0E00-\\u0E7F\\uAC00-\\uD7AF\\u0600-\\u06FF\\u0080-\\u00FF\\u0100-\\u017F]+|[^A-Za-z0-9\\u4E00-\\u9FA5\\u3040-\\u31FE\\u0400-\\u04FF\\u0E00-\\u0E7F\\uAC00-\\uD7AF\\u0600-\\u06FF\\u0080-\\u00FF\\u0100-\\u017F]+$", " ");
            return value;
        }
        return "";
    }

    public String toString() {
        return "[" + this.original + "]" + Arrays.toString((Object[])this.mappings) + "[" + this.normalized + "]";
    }

    public String trimOriginal() {
        return this.original.trim();
    }

    public Integer[] getMappings() {
        return this.mappings;
    }

    public void setMappings(Integer[] mappings) {
        this.mappings = mappings;
    }

    public String getNormalized() {
        return this.normalized;
    }

    public void setNormalized(String normalized) {
        this.normalized = normalized;
        if (normalized != null) {
            this.splitted = normalized.trim().split(" ");
        }
    }

    public String getOriginal() {
        return this.original;
    }

    public void setOriginal(String original) {
        this.original = original;
    }
}

