/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.util.elva.text;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aihelp.core.util.elva.util.Escaper;

public class SentenceSplitter {
    private final Map<String, String> protection;
    private final List<String> splitters;
    private final Pattern pattern;

    public SentenceSplitter(Map<String, String> protection, List<String> splitters) {
        this.protection = protection;
        this.splitters = splitters;
        String splitPattern = "[ \\s]*(";
        Iterator<String> i = splitters.iterator();
        while (true) {
            splitPattern = splitPattern + Escaper.escapeRegex(i.next());
            if (!i.hasNext()) break;
            splitPattern = splitPattern + "|";
        }
        splitPattern = splitPattern + ")[ \\s]*";
        this.pattern = Pattern.compile(splitPattern);
    }

    private String protect(String input) {
        for (String find : this.protection.keySet()) {
            Pattern pattern = Pattern.compile(find, 66);
            Matcher matcher = pattern.matcher(input);
            String replace = this.protection.get(find);
            input = matcher.replaceAll(replace);
        }
        return input;
    }

    private String[] split(String original, String prepared) {
        String[] splitted;
        Matcher matcher = this.pattern.matcher(prepared);
        LinkedList<String> sentences = new LinkedList<String>();
        int beginIndex = 0;
        while (matcher.find()) {
            int endIndex = matcher.start();
            String sentence = original.substring(beginIndex, endIndex) + matcher.group(1);
            if (!this.splitters.contains(sentence.trim())) {
                sentences.add(sentence);
            }
            beginIndex = endIndex + matcher.group().length();
        }
        if (sentences.size() > 0) {
            splitted = new String[sentences.size()];
            sentences.toArray(splitted);
        } else {
            splitted = new String[]{original};
        }
        return splitted;
    }

    public String[] split(String original) {
        return this.split(original, this.protect(original));
    }
}

