/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.util.elva.text;

import java.util.List;
import net.aihelp.core.util.elva.text.Tokenizer;

public class Substitution {
    private FindReplaceOperation operation;
    private String find;
    private String replace;
    private Tokenizer tokenizer;

    public Substitution() {
    }

    public Substitution(String find, String replace, Tokenizer tokenizer) {
        this.setFind(find);
        this.setReplace(replace);
        this.setTokenizer(tokenizer);
    }

    private void afterSetProperty() {
        if (this.find == null || this.tokenizer == null || this.replace == null) {
            return;
        }
        List<String> tokens = this.tokenizer.tokenize(this.find);
        this.operation = tokens.size() > 1 ? new FindReplaceFragment(tokens) : (this.find.charAt(0) != ' ' ? new FindReplaceSuffix() : (this.find.charAt(this.find.length() - 1) != ' ' ? new FindReplacePrefix() : new FindReplaceWord()));
        this.find = this.find.toUpperCase().trim();
    }

    public void substitute(List<String> input) {
        if (this.operation == null) {
            throw new NullPointerException("Substitution state incomplete\nFind: " + this.find + '\n' + "Replace: " + this.replace + '\n' + "Tokenizer: " + this.tokenizer);
        }
        int i = 0;
        while (i < input.size()) {
            if (this.operation.matches(i, input)) {
                i += this.operation.replacement(i, input);
                continue;
            }
            ++i;
        }
    }

    public int substitute(int offset, List<String> input) {
        if (this.operation == null) {
            throw new NullPointerException("Substitution state incomplete\nFind: " + this.find + '\n' + "Replace: " + this.replace + '\n' + "Tokenizer: " + this.tokenizer);
        }
        if (this.operation.matches(offset, input)) {
            offset += this.operation.replacement(offset, input);
        }
        return offset;
    }

    public String getFind() {
        return this.find;
    }

    public void setFind(String find) {
        this.find = find;
        this.afterSetProperty();
    }

    public String getReplace() {
        return this.replace;
    }

    public void setReplace(String replace) {
        this.replace = replace;
        this.afterSetProperty();
    }

    public Tokenizer getTokenizer() {
        return this.tokenizer;
    }

    public void setTokenizer(Tokenizer tokenizer) {
        this.tokenizer = tokenizer;
        this.afterSetProperty();
    }

    private class FindReplaceWord
    implements FindReplaceOperation {
        private final List<String> replacement;

        private FindReplaceWord() {
            this.replacement = Substitution.this.tokenizer.tokenize(Substitution.this.replace);
        }

        @Override
        public boolean matches(int index, List<String> input) {
            String token = input.get(index);
            return Substitution.this.find.equalsIgnoreCase(token);
        }

        @Override
        public int replacement(int index, List<String> tokens) {
            tokens.remove(index);
            tokens.addAll(index, this.replacement);
            return this.replacement.size();
        }
    }

    private class FindReplaceSuffix
    implements FindReplaceOperation {
        private String token;
        private String TOKEN;

        private FindReplaceSuffix() {
        }

        @Override
        public boolean matches(int index, List<String> input) {
            this.token = input.get(index);
            this.TOKEN = this.token.toUpperCase();
            return this.TOKEN.endsWith(Substitution.this.find);
        }

        @Override
        public int replacement(int index, List<String> tokens) {
            int endIndex = this.TOKEN.lastIndexOf(Substitution.this.find);
            List<String> replacement = Substitution.this.tokenizer.tokenize(this.token.substring(0, endIndex) + Substitution.this.replace);
            tokens.remove(index);
            tokens.addAll(index, replacement);
            return replacement.size();
        }
    }

    private class FindReplacePrefix
    implements FindReplaceOperation {
        private String token;
        private String TOKEN;

        private FindReplacePrefix() {
        }

        @Override
        public boolean matches(int index, List<String> input) {
            this.token = input.get(index);
            this.TOKEN = this.token.toUpperCase();
            return this.TOKEN.indexOf(Substitution.this.find) == 0;
        }

        @Override
        public int replacement(int index, List<String> tokens) {
            int beginIndex = Substitution.this.find.length();
            List<String> replacement = Substitution.this.tokenizer.tokenize(Substitution.this.replace + this.token.substring(beginIndex));
            tokens.remove(index);
            tokens.addAll(index, replacement);
            return replacement.size();
        }
    }

    private class FindReplaceFragment
    implements FindReplaceOperation {
        private final List<String> replacement;
        private final List<String> fragment;

        FindReplaceFragment(List<String> fragment) {
            this.replacement = Substitution.this.tokenizer.tokenize(Substitution.this.replace);
            this.fragment = fragment;
        }

        @Override
        public boolean matches(int index, List<String> input) {
            int i = 0;
            int n = index + this.fragment.size();
            for (int j = index; j < n; ++j) {
                String token = this.fragment.get(i);
                String find = input.get(j);
                if (!find.equalsIgnoreCase(token)) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        @Override
        public int replacement(int index, List<String> tokens) {
            int n = this.fragment.size();
            for (int i = 0; i < n; ++i) {
                tokens.remove(index);
            }
            tokens.addAll(index, this.replacement);
            return this.replacement.size();
        }
    }

    private static interface FindReplaceOperation {
        public boolean matches(int var1, List<String> var2);

        public int replacement(int var1, List<String> var2);
    }
}

